/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.codegen.writer.RecursiveDefinitionWriter;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.decomposed.DecomposedExpression;
import org.simantics.scl.compiler.elaboration.expressions.Assignment;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.internal.StronglyConnectedComponents;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.Locations;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class ELet
extends Expression {
    Assignment[] assignments;
    Expression in;

    public ELet(long loc, Assignment[] assignments, Expression in) {
        super(loc);
        this.assignments = assignments;
        this.in = in;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            Assignment assign = assignmentArray[n2];
            assign.value.collectRefs(allRefs, refs);
            ++n2;
        }
        this.in.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            Assignment assign = assignmentArray[n2];
            assign.value.collectVars(allVars, vars);
            ++n2;
        }
        this.in.collectVars(allVars, vars);
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("{");
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            Assignment assign = assignmentArray[n2];
            assign.pattern.toString(b, tuc);
            b.append(" = ");
            assign.value.toString(b, tuc);
            b.append("; ");
            ++n2;
        }
        this.in.toString(b, tuc);
        b.append("}");
    }

    @Override
    public void toString(PrintingContext context, int precedence) {
        if (precedence < 2) {
            context.append("(");
        }
        context.append("let ");
        context.indent();
        int i = 0;
        while (i < this.assignments.length) {
            if (i > 0) {
                context.newLine();
            }
            Assignment assignment = this.assignments[i];
            assignment.pattern.toString(context, 10);
            context.append(" = ");
            assignment.value.toString(context, 10);
            ++i;
        }
        context.dedent();
        context.newLine();
        context.append("in ");
        this.in.toString(context, 10);
        if (precedence < 2) {
            context.append(")");
        }
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            Assignment assign = assignmentArray[n2];
            assign.pattern.validateType(environment);
            assign.value.validateType(environment);
            ELet.assertEquals(assign.pattern.location, assign.pattern.getType(), assign.value.getType());
            ++n2;
        }
        this.in.validateType(environment);
        this.setType(this.in.getType());
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.in.getType());
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            Assignment assignment = assignmentArray[n2];
            assignment.value = assignment.value.simplify(context);
            ++n2;
        }
        final TObjectIntHashMap allVars = new TObjectIntHashMap(2 * this.assignments.length, 0.5f, -1);
        int i = 0;
        while (i < this.assignments.length) {
            for (Variable var : this.assignments[i].pattern.getFreeVariables()) {
                allVars.put((Object)var, i);
            }
            ++i;
        }
        final boolean[] isRecursive = new boolean[this.assignments.length];
        final ArrayList components = new ArrayList(Math.max(10, this.assignments.length));
        new StronglyConnectedComponents(this.assignments.length){

            @Override
            protected int[] findDependencies(int u) {
                TIntHashSet vars = new TIntHashSet();
                ELet.this.assignments[u].value.collectVars((TObjectIntHashMap<Variable>)allVars, vars);
                if (vars.contains(u)) {
                    isRecursive[u] = true;
                }
                return vars.toArray();
            }

            @Override
            protected void reportComponent(int[] component) {
                components.add(component);
            }
        }.findComponents();
        Expression result = this.in.simplify(context);
        int j = components.size() - 1;
        while (j >= 0) {
            boolean recursive;
            int[] component = (int[])components.get(j);
            boolean bl = recursive = component.length > 1 || isRecursive[component[0]];
            if (recursive) {
                Assignment[] cAssignments = new Assignment[component.length];
                int i2 = 0;
                while (i2 < component.length) {
                    cAssignments[i2] = this.assignments[component[i2]];
                    ++i2;
                }
                result = new ELet(this.location, cAssignments, result);
            } else {
                Assignment assignment = this.assignments[component[0]];
                Expression pattern = assignment.pattern;
                if (pattern instanceof EVariable) {
                    EVariable pvar = (EVariable)pattern;
                    result = new ESimpleLet(this.location, pvar.variable, assignment.value, result);
                } else {
                    result = new EMatch(this.location, new Expression[]{assignment.value}, new Case(new Expression[]{pattern}, result));
                }
            }
            --j;
        }
        return result;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        Assignment assign;
        this.in.collectFreeVariables(vars);
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            assign = assignmentArray[n2];
            assign.value.collectFreeVariables(vars);
            ++n2;
        }
        assignmentArray = this.assignments;
        n = this.assignments.length;
        n2 = 0;
        while (n2 < n) {
            assign = assignmentArray[n2];
            assign.pattern.removeFreeVariables(vars);
            ++n2;
        }
    }

    @Override
    public Expression resolve(TranslationContext context) {
        throw new InternalCompilerError("ELet should be already resolved.");
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Assignment[] newAssignments = new Assignment[this.assignments.length];
        int i = 0;
        while (i < this.assignments.length) {
            newAssignments[i] = this.assignments[i].replace(context);
            ++i;
        }
        Expression newIn = this.in.replace(context);
        return new ELet(this.getLocation(), newAssignments, newIn);
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        BoundVar[] vars = new BoundVar[this.assignments.length];
        int i = 0;
        while (i < this.assignments.length) {
            Expression pattern = this.assignments[i].pattern;
            if (!(pattern instanceof EVariable)) {
                throw new InternalCompilerError("Cannot handle pattern targets in recursive assignments.");
            }
            vars[i] = new BoundVar(pattern.getType());
            ((EVariable)pattern).getVariable().setVal(vars[i]);
            ++i;
        }
        RecursiveDefinitionWriter rdw = w.createRecursiveDefinition();
        long range = 9223372034707292160L;
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            Assignment assign2 = assignmentArray[n2];
            range = Locations.combine(range, assign2.pattern.location);
            range = Locations.combine(range, assign2.value.location);
            ++n2;
        }
        rdw.setLocation(range);
        int i2 = 0;
        while (i2 < this.assignments.length) {
            DecomposedExpression decomposed = DecomposedExpression.decompose(this.assignments[i2].value);
            CodeWriter newW = rdw.createFunction(vars[i2], decomposed.typeParameters, decomposed.effect, decomposed.returnType, decomposed.parameterTypes);
            IVal[] parameters = newW.getParameters();
            int j = 0;
            while (j < parameters.length) {
                decomposed.parameters[j].setVal(parameters[j]);
                ++j;
            }
            newW.return_(decomposed.body.toVal(env, newW));
            ++i2;
        }
        return this.in.toVal(env, w);
    }

    private void checkAssignments(TypingContext context) {
        Assignment assign;
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            assign = assignmentArray[n2];
            assign.pattern = assign.pattern.checkTypeAsPattern(context, Types.metaVar(Kinds.STAR));
            ++n2;
        }
        assignmentArray = this.assignments;
        n = this.assignments.length;
        n2 = 0;
        while (n2 < n) {
            assign = assignmentArray[n2];
            assign.value = assign.value.checkType(context, assign.pattern.getType());
            ++n2;
        }
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.checkAssignments(context);
        this.in = this.in.inferType(context);
        return this;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.checkAssignments(context);
        this.in = this.in.checkType(context, requiredType);
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        this.in = this.in.decorate(decorator);
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            Assignment assignment = assignmentArray[n2];
            assignment.decorate(decorator);
            ++n2;
        }
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        Assignment[] assignmentArray = this.assignments;
        int n = this.assignments.length;
        int n2 = 0;
        while (n2 < n) {
            Assignment assignment = assignmentArray[n2];
            assignment.pattern.collectEffects(effects);
            assignment.value.collectEffects(effects);
            ++n2;
        }
        this.in.collectEffects(effects);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Assignment[] assignmentArray = this.assignments;
            int n = this.assignments.length;
            int n2 = 0;
            while (n2 < n) {
                Assignment assignment = assignmentArray[n2];
                assignment.setLocationDeep(loc);
                ++n2;
            }
            this.in.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

