/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.interpreted.IExpression;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class ELambdaType
extends Expression {
    public TVar[] parameters;
    public Expression value;

    public ELambdaType(TVar[] parameters, Expression value) {
        super(value.getLocation());
        this.parameters = parameters;
        this.value = value;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        this.value.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.value.collectVars(allVars, vars);
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("(\\");
        TVar[] tVarArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TVar parameter = tVarArray[n2];
            b.append('<');
            b.append(parameter.toString(tuc));
            b.append("> ");
            ++n2;
        }
        b.append("-> ");
        this.value.toString(b, tuc);
        b.append(")");
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        this.value.validateType(environment);
        this.setType(Types.forAll(this.parameters, this.value.getType()));
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.forAll(this.parameters, this.value.getType()));
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        return this.lambdaToVal(env, w);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.value.collectFreeVariables(vars);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.value = this.value.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        TVar[] newParameters = new TVar[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            TVar var;
            newParameters[i] = var = Types.var(this.parameters[i].getKind());
            context.tvarMap.put((Object)this.parameters[i], (Object)var);
            ++i;
        }
        ELambdaType result = new ELambdaType(newParameters, this.value.replace(context));
        int i2 = 0;
        while (i2 < this.parameters.length) {
            context.tvarMap.remove((Object)this.parameters[i2]);
            ++i2;
        }
        return result;
    }

    @Override
    public IExpression toIExpression(SCLValueCache valueCache) {
        return this.value.toIExpression(valueCache);
    }

    @Override
    public Expression inferType(TypingContext context) {
        throw new InternalCompilerError("Should not type check " + this.getClass().getSimpleName() + ".");
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        this.value = this.value.decorate(decorator);
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.value.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

