/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.codegen.values.DoubleConstant;
import org.simantics.scl.compiler.codegen.values.FloatConstant;
import org.simantics.scl.compiler.codegen.values.IntegerConstant;
import org.simantics.scl.compiler.codegen.values.LongConstant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EIntegerLiteral
extends SimplifiableExpression {
    String value;
    EVariable constraint;

    public EIntegerLiteral(String value) {
        this.value = value;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append(this.value);
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        requiredType = Types.canonical(requiredType);
        try {
            if (requiredType.equals(Types.INTEGER)) {
                return new ELiteral(new IntegerConstant(Integer.parseInt(this.value)));
            }
            if (requiredType.equals(Types.DOUBLE)) {
                return new ELiteral(new DoubleConstant(Double.parseDouble(this.value)));
            }
            if (requiredType.equals(Types.FLOAT)) {
                return new ELiteral(new FloatConstant(Float.parseFloat(this.value)));
            }
            if (requiredType.equals(Types.LONG)) {
                return new ELiteral(new LongConstant(Long.parseLong(this.value)));
            }
        }
        catch (NumberFormatException e) {
            context.getErrorLog().log(this.getLocation(), "Invalid number format.");
        }
        this.setType(requiredType);
        this.constraint = new EVariable(this.location, null);
        this.constraint.setType(Types.pred(Types.RING, requiredType));
        context.addConstraintDemand(this.constraint);
        return this;
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
    }

    @Override
    protected void updateType() throws MatchException {
        throw new InternalCompilerError();
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        try {
            return context.apply(context.getConstant(SimplificationContext.FROM_INTEGER, this.getType()), this.constraint.simplify(context), context.literal(new IntegerConstant(Integer.parseInt(this.value))));
        }
        catch (NumberFormatException e) {
            context.getErrorLog().log(this.getLocation(), "Invalid number format (maybe too long for the expected number type).");
            return this;
        }
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return new ELiteral(new IntegerConstant(Integer.parseInt(this.value)));
    }

    @Override
    public Expression replace(ReplaceContext context) {
        EIntegerLiteral copy = new EIntegerLiteral(this.value);
        copy.setType(this.getType().replace(context.tvarMap));
        return copy;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public boolean isEffectful() {
        return false;
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            if (this.constraint != null) {
                this.constraint.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

