/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EIf
extends Expression {
    Expression condition;
    Expression then_;
    Expression else_;

    public EIf(Expression condition, Expression then_, Expression else_) {
        this.condition = condition;
        this.then_ = then_;
        this.else_ = else_;
    }

    public EIf(long loc, Expression condition, Expression then_, Expression else_) {
        super(loc);
        this.condition = condition;
        this.then_ = then_;
        this.else_ = else_;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        this.condition.collectRefs(allRefs, refs);
        this.then_.collectRefs(allRefs, refs);
        this.else_.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.condition.collectVars(allVars, vars);
        this.then_.collectVars(allVars, vars);
        this.else_.collectVars(allVars, vars);
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("(if ");
        this.condition.toString(b, tuc);
        b.append(" then ");
        this.then_.toString(b, tuc);
        b.append(" else ");
        this.else_.toString(b, tuc);
        b.append(")");
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        this.condition.validateType(environment);
        this.then_.validateType(environment);
        this.else_.validateType(environment);
        EIf.assertEquals(this.location, this.condition.getType(), Types.BOOLEAN);
        EIf.assertEquals(this.location, this.then_.getType(), this.else_.getType());
        this.setType(this.then_.getType());
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.then_.getType());
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        IVal conditionVal = this.condition.toVal(env, w);
        CodeWriter thenBlock = w.createBlock(new Type[0]);
        CodeWriter elseBlock = w.createBlock(new Type[0]);
        CodeWriter joinPoint = w.createBlock(this.getType());
        w.if_(conditionVal, thenBlock.getContinuation(), elseBlock.getContinuation());
        IVal thenVal = this.then_.toVal(env, thenBlock);
        thenBlock.jump(joinPoint.getContinuation(), thenVal);
        IVal elseVal = this.else_.toVal(env, elseBlock);
        elseBlock.jump(joinPoint.getContinuation(), elseVal);
        w.continueAs(joinPoint);
        return w.getParameters()[0];
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.condition.collectFreeVariables(vars);
        this.then_.collectFreeVariables(vars);
        this.else_.collectFreeVariables(vars);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.condition = this.condition.simplify(context);
        this.then_ = this.then_.simplify(context);
        this.else_ = this.else_.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.condition = this.condition.resolve(context);
        this.then_ = this.then_.resolve(context);
        this.else_ = this.else_.resolve(context);
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        return new EIf(this.condition.replace(context), this.then_.replace(context), this.else_.replace(context));
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.condition = this.condition.checkType(context, Types.BOOLEAN);
        this.then_ = this.then_.checkType(context, requiredType);
        this.else_ = this.else_.checkType(context, requiredType);
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        this.condition = this.condition.decorate(decorator);
        this.then_ = this.then_.decorate(decorator);
        this.else_ = this.else_.decorate(decorator);
        return decorator.decorate(this);
    }

    @Override
    public boolean isEffectful() {
        return this.condition.isEffectful() || this.then_.isEffectful() || this.else_.isEffectful();
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.condition.collectEffects(effects);
        this.then_.collectEffects(effects);
        this.else_.collectEffects(effects);
    }

    @Override
    public void toString(PrintingContext context, int precedence) {
        if (precedence < 2) {
            context.append("(");
        }
        context.append("if ");
        this.condition.toString(context, 10);
        context.append(" then ");
        this.then_.toString(context, 10);
        context.append(" else ");
        this.else_.toString(context, 10);
        if (precedence < 2) {
            context.append(")");
        }
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.condition.setLocationDeep(loc);
            this.then_.setLocationDeep(loc);
            this.else_.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

