/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EGetConstraint
extends SimplifiableExpression {
    TPred constraint;
    EVariable evidence;

    public EGetConstraint(long loc, TPred constraint) {
        super(loc);
        this.constraint = constraint;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        if (this.evidence != null) {
            this.evidence.collectVars(allVars, vars);
        }
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        if (this.evidence != null) {
            this.evidence.toString(b, tuc);
        } else {
            b.append("<<" + this.constraint.toString(tuc) + ">>");
        }
    }

    @Override
    public Expression inferType(TypingContext context) {
        Variable variable = new Variable("evidence");
        variable.setType(this.constraint);
        this.evidence = new EVariable(this.getLocation(), variable);
        this.evidence.setType(variable.getType());
        context.addConstraintDemand(this.evidence);
        return this;
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.constraint);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        if (this.evidence != null) {
            this.evidence.collectFreeVariables(vars);
        }
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        return this.evidence.simplify(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            if (this.evidence != null) {
                this.evidence.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

