/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EEnforce
extends SimplifiableExpression {
    Query query;

    public EEnforce(Query query) {
        this.query = query;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        this.query.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.query.collectVars(allVars, vars);
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("<enforce>");
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.tupleConstructor(0));
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.query.checkType(context);
        context.declareEffect(this.location, this.query.getEffect(2));
        return this;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.query.collectFreeVariables(vars);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.query.simplify(context);
        return this.query.generateEnforce(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.pushExistentialFrame();
        this.query = this.query.resolve(context);
        Variable[] variables = context.popExistentialFrame();
        if (variables.length > 0) {
            this.query = new QExists(variables, this.query);
        }
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    public Type getLocalEffect() {
        return this.query.getEffect(2);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.query.collectEffects(2, effects);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.query.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

