/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EPlaceholder;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.PatternMatchingLhs;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.interpreted.IConstant;
import org.simantics.scl.compiler.interpreted.IExpression;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.types.TForAll;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.MultiFunction;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EConstant
extends Expression {
    SCLValue value;
    Type[] typeParameters;

    public EConstant(SCLValue value, Type ... typeParameters) {
        this.value = value;
        this.typeParameters = typeParameters;
    }

    public EConstant(SCLValue value) {
        this.value = value;
        this.typeParameters = Type.EMPTY_ARRAY;
    }

    public EConstant(long loc, SCLValue value) {
        super(loc);
        this.value = value;
        this.typeParameters = Type.EMPTY_ARRAY;
    }

    public EConstant(long loc, SCLValue value, Type ... typeParameters) {
        super(loc);
        this.value = value;
        this.typeParameters = typeParameters;
    }

    public void addTypeParameters(Type ... newTypeParameters) {
        this.typeParameters = Types.concat(this.typeParameters, newTypeParameters);
    }

    @Override
    public Expression applyType(Type type) {
        this.typeParameters = Types.concat(this.typeParameters, new Type[]{type});
        if (this.getType() != null) {
            this.setType(Types.instantiate(this.getType(), type));
        }
        return this;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        int id = allRefs.get((Object)this.value);
        if (id >= 0) {
            refs.add(id);
        }
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        Name name = this.value.getName();
        if (name.module.equals("Builtin") || name.module.equals("Prelude")) {
            b.append(name.name);
        } else {
            b.append(name);
        }
    }

    @Override
    public void toString(PrintingContext context, int precedence) {
        Name name = this.value.getName();
        if (name.module.equals("Builtin") || name.module.equals("Prelude")) {
            context.append(name.name);
        } else {
            context.append(name);
        }
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        this.setType(Types.instantiate(this.value.getType(), this.typeParameters));
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.instantiate(this.value.getType(), this.typeParameters));
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        IVal val = this.value.getValue();
        if (this.typeParameters.length > 0) {
            val = val.createSpecialization(this.typeParameters);
        }
        return val;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        if (this.value.getInlineInSimplification()) {
            if (this.typeParameters.length > 0) {
                context.getErrorLog().log(this.location, "Inlining with type parameters not currently supported in simplification.");
                return this;
            }
            return this.value.getExpression().copy().simplify(context);
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }

    @Override
    public void getParameters(TranslationContext translationContext, ArrayList<Expression> parameters) {
    }

    public SCLValue getValue() {
        return this.value;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this;
    }

    @Override
    public void removeFreeVariables(THashSet<Variable> vars) {
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Type[] newTypeParameters;
        if (this.typeParameters.length == 0) {
            newTypeParameters = Type.EMPTY_ARRAY;
        } else {
            newTypeParameters = new Type[this.typeParameters.length];
            int i = 0;
            while (i < newTypeParameters.length) {
                newTypeParameters[i] = this.typeParameters[i].replace(context.tvarMap);
                ++i;
            }
        }
        return new EConstant(this.value, newTypeParameters);
    }

    public Type[] getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public LhsType getLhsType() throws NotPatternException {
        return new PatternMatchingLhs();
    }

    @Override
    public IExpression toIExpression(SCLValueCache valueCache) {
        return new IConstant(valueCache.getValue(this.value));
    }

    @Override
    public Expression inferType(TypingContext context) {
        if (context.recursiveValues != null && context.recursiveValues.contains((Object)this.value)) {
            EPlaceholder placeholder = new EPlaceholder(this.location, this);
            placeholder.setType(this.value.getType());
            context.recursiveReferences.add(placeholder);
            return placeholder;
        }
        if (context.isInPattern()) {
            Type resultType = this.value.getType();
            if (resultType instanceof TForAll) {
                ArrayList<TMetaVar> vars = new ArrayList<TMetaVar>();
                resultType = Types.instantiate(resultType, vars);
                MultiFunction mfun = Types.matchFunction(resultType);
                resultType = mfun.returnType;
                for (TMetaVar var : vars) {
                    if (resultType.contains(var)) break;
                    this.addTypeParameters(Types.var(var.getKind()));
                }
            }
            return this;
        }
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public boolean isEffectful() {
        return false;
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

