/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import java.util.LinkedList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EPreLet;
import org.simantics.scl.compiler.elaboration.expressions.EPreRuleset;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.RuleStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EBlock
extends ASTExpression {
    LinkedList<Statement> statements = new LinkedList();
    boolean monadic;

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public void setMonadic(boolean monadic) {
        this.monadic = monadic;
    }

    public LinkedList<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("du { ");
        boolean first = true;
        for (Statement statement : this.statements) {
            if (first) {
                first = false;
            } else {
                b.append(" ; ");
            }
            statement.toString(b, tuc);
        }
        b.append(" }");
    }

    @Override
    public Expression resolve(TranslationContext context) {
        if (this.statements.isEmpty()) {
            throw new InternalCompilerError();
        }
        int i = this.statements.size() - 1;
        Statement last = this.statements.get(i);
        if (!(last instanceof GuardStatement)) {
            context.getErrorLog().log(last.location, "Block should end with an expression");
            return new EError(this.location);
        }
        Expression in = ((GuardStatement)last).value;
        while (--i >= 0) {
            int endId;
            Statement cur = this.statements.get(i);
            if (cur instanceof RuleStatement) {
                endId = i + 1;
                while (i > 0 && this.statements.get(i - 1) instanceof RuleStatement) {
                    --i;
                }
                in = this.extractRules(i, endId, in);
                continue;
            }
            if (cur instanceof LetStatement && ((LetStatement)cur).pattern.isFunctionPattern()) {
                endId = i + 1;
                while (i > 0 && (cur = this.statements.get(i - 1)) instanceof LetStatement && ((LetStatement)cur).pattern.isFunctionPattern()) {
                    --i;
                }
                in = this.extractLet(i, endId, in);
                continue;
            }
            in = cur.toExpression(context, this.monadic, in);
        }
        return in.resolve(context);
    }

    private Expression extractRules(int begin, int end, Expression in) {
        return new EPreRuleset(this.statements.subList(begin, end).toArray(new RuleStatement[end - begin]), in);
    }

    private Expression extractLet(int begin, int end, Expression in) {
        return new EPreLet(this.statements.subList(begin, end), in);
    }

    public static Expression create(ArrayList<Expression> statements) {
        EBlock block = new EBlock();
        for (Expression statement : statements) {
            block.addStatement(new GuardStatement(statement));
        }
        return block;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            for (Statement statement : this.statements) {
                statement.setLocationDeep(loc);
            }
        }
    }
}

