/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.precedence.Associativity;
import org.simantics.scl.compiler.common.precedence.Precedence;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EBinaryRightSide;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.FunctionDefinitionLhs;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.Locations;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EBinary
extends ASTExpression {
    public static final int NEGATION_LEVEL = 6;
    public final Expression left;
    public final ArrayList<EBinaryRightSide> rights = new ArrayList();
    public EVar negation;

    public EBinary(Expression left, EVar negation) {
        this.left = left;
        this.negation = negation;
    }

    private EBinary(Expression left, EVar operator, Expression right) {
        this.left = left;
        this.rights.add(new EBinaryRightSide(operator, right));
    }

    public static EBinary create(Expression left, EVar operator, Expression right) {
        if (left instanceof EBinary) {
            EBinary left_ = (EBinary)left;
            left_.rights.add(new EBinaryRightSide(operator, right));
            return left_;
        }
        return new EBinary(left, operator, right);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this.parseOperators(context).resolve(context);
    }

    public Expression parseOperators(TranslationContext context) {
        ArrayList<Expression> output = new ArrayList<Expression>();
        ArrayList<SCLValue> ops = new ArrayList<SCLValue>();
        ArrayList<EVar> opAsts = new ArrayList<EVar>();
        EVar negation = this.negation;
        output.add(this.left);
        for (EBinaryRightSide right : this.rights) {
            SCLValue op = context.resolveValue(right.operator.name);
            if (op == null) {
                context.getErrorLog().log(right.operator.location, "Couldn't resolve variable " + right.operator.name + ".");
                return new EError(this.location);
            }
            Precedence opPrec = op.getPrecedence();
            while (!ops.isEmpty()) {
                SCLValue oldOp = (SCLValue)ops.get(ops.size() - 1);
                Precedence oldOpPrecedence = oldOp.getPrecedence();
                if (oldOpPrecedence.level < opPrec.level) break;
                if (oldOpPrecedence.level == opPrec.level) {
                    if (opPrec.associativity == Associativity.RIGHT) break;
                    if (opPrec.associativity == Associativity.NONASSOC) {
                        context.getErrorLog().log(right.operator.location, "Operator " + right.operator.name + " is not associative.");
                        return new EError(this.location);
                    }
                }
                ops.remove(ops.size() - 1);
                Expression r = (Expression)output.remove(output.size() - 1);
                Expression l = (Expression)output.remove(output.size() - 1);
                output.add(this.binary(l, oldOp, (EVar)opAsts.remove(opAsts.size() - 1), r));
            }
            if (negation != null && ops.isEmpty() && opPrec.level <= 6) {
                SCLValue neg = context.resolveValue("neg");
                if (neg == null) {
                    context.getErrorLog().log(this.location, "Couldn't resolve variable neg.");
                    return new EError(this.location);
                }
                output.set(0, this.unary(neg, negation, (Expression)output.get(0)));
                negation = null;
            }
            ops.add(op);
            opAsts.add(right.operator);
            output.add(right.right);
        }
        while (!ops.isEmpty()) {
            SCLValue oldOp = (SCLValue)ops.remove(ops.size() - 1);
            Expression r = (Expression)output.remove(output.size() - 1);
            Expression l = (Expression)output.remove(output.size() - 1);
            output.add(this.binary(l, oldOp, (EVar)opAsts.remove(opAsts.size() - 1), r));
        }
        if (negation != null) {
            SCLValue neg = context.resolveValue("neg");
            if (neg == null) {
                context.getErrorLog().log(this.location, "Couldn't resolve variable neg.");
                return new EError(this.location);
            }
            output.set(0, this.unary(neg, negation, (Expression)output.get(0)));
        }
        return (Expression)output.get(0);
    }

    private Expression binary(Expression lhs, SCLValue operator, EVar opAst, Expression rhs) {
        EConstant op = new EConstant(opAst.getLocation(), operator);
        return new EApply(Locations.combine(lhs.location, rhs.location), (Expression)op, lhs, rhs);
    }

    private Expression unary(SCLValue operator, EVar opAst, Expression expression) {
        EConstant op = new EConstant(opAst.location, operator);
        return new EApply(expression.location, (Expression)op, expression);
    }

    @Override
    public String getPatternHead() throws NotPatternException {
        if (this.rights.size() == 1) {
            return this.rights.get((int)0).operator.name;
        }
        throw new NotPatternException(this);
    }

    @Override
    public LhsType getLhsType() throws NotPatternException {
        if (this.rights.size() == 1) {
            return new FunctionDefinitionLhs(this.rights.get((int)0).operator.name);
        }
        throw new InternalCompilerError();
    }

    @Override
    public void getParameters(TranslationContext context, ArrayList<Expression> parameters) {
        this.parseOperators(context).getParameters(context, parameters);
    }

    public static Expression negate(EVar op, Expression expression) {
        if (expression instanceof EBinary) {
            ((EBinary)expression).negation = op;
            return expression;
        }
        return new EBinary(expression, op);
    }

    @Override
    public int getFunctionDefinitionArity() throws NotPatternException {
        return 2;
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append('(');
        if (this.negation != null) {
            b.append("- ");
        }
        this.left.toString(b, tuc);
        for (EBinaryRightSide right : this.rights) {
            b.append(' ').append(right.operator.name).append(' ');
            right.right.toString(b, tuc);
        }
        b.append(')');
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.left.setLocationDeep(loc);
            if (this.negation != null) {
                this.negation.setLocationDeep(loc);
            }
            for (EBinaryRightSide right : this.rights) {
                right.setLocationDeep(loc);
            }
        }
    }
}

