/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.PatternMatchingLhs;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.interpreted.IApply;
import org.simantics.scl.compiler.interpreted.IExpression;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.exceptions.UnificationException;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.MultiFunction;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EApply
extends Expression {
    Expression function;
    Expression[] parameters;
    Type effect = Types.NO_EFFECTS;

    public EApply(Expression function, Expression ... parameters) {
        this.function = function;
        this.parameters = parameters;
    }

    public EApply(Expression function, Expression parameter) {
        this(function, new Expression[]{parameter});
    }

    public EApply(long loc, Expression function, Expression ... parameters) {
        super(loc);
        this.function = function;
        this.parameters = parameters;
    }

    public EApply(long loc, Type effect, Expression function, Expression ... parameters) {
        super(loc);
        this.effect = effect;
        this.function = function;
        this.parameters = parameters;
    }

    public void set(Expression function, Expression[] parameters) {
        this.function = function;
        this.parameters = parameters;
    }

    public Expression getFunction() {
        return this.function;
    }

    public Expression[] getParameters() {
        return this.parameters;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        this.function.collectRefs(allRefs, refs);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectRefs(allRefs, refs);
            ++n2;
        }
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.function.collectVars(allVars, vars);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectVars(allVars, vars);
            ++n2;
        }
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("(");
        EApply.toString(b, this, tuc);
        b.append(")");
    }

    private static void toString(StringBuilder b, Expression exp, TypeUnparsingContext tuc) {
        if (exp instanceof EApply) {
            EApply apply = (EApply)exp;
            EApply.toString(b, apply.function, tuc);
            Expression[] expressionArray = apply.parameters;
            int n = apply.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                b.append(' ');
                parameter.toString(b, tuc);
                ++n2;
            }
        } else if (exp instanceof EApplyType) {
            EApplyType apply = (EApplyType)exp;
            EApply.toString(b, apply.expression, tuc);
            b.append(" <");
            b.append(apply.parameter.toString(tuc));
            b.append(">");
        } else {
            exp.toString(b, tuc);
        }
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        MultiFunction mfun;
        this.function.validateType(environment);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.validateType(environment);
            ++n2;
        }
        try {
            mfun = Types.matchFunction(this.function.getType(), this.parameters.length);
        }
        catch (MatchException e) {
            throw new Expression.TypeValidationException(this.location, (Throwable)e);
        }
        int i = 0;
        while (i < this.parameters.length) {
            EApply.assertEquals(this.location, mfun.parameterTypes[i], this.parameters[i].getType());
            ++i;
        }
        this.effect = mfun.effect;
        this.setType(mfun.returnType);
    }

    @Override
    protected void updateType() throws MatchException {
        MultiFunction mfun = Types.matchFunction(this.function.getType(), this.parameters.length);
        this.effect = mfun.effect;
        this.setType(mfun.returnType);
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        IVal functionVal = this.function.toVal(env, w);
        IVal[] parameterVals = new IVal[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            parameterVals[i] = this.parameters[i].toVal(env, w);
            ++i;
        }
        Type type = this.getType();
        this.effect = Types.simplifyFinalEffect(this.effect);
        return w.applyWithEffect(this.location, this.effect, type, functionVal, parameterVals);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.function.collectFreeVariables(vars);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectFreeVariables(vars);
            ++n2;
        }
    }

    private void combineApplications() {
        if (this.function instanceof EApply) {
            EApply apply = (EApply)this.function;
            this.function = apply.function;
            this.parameters = Expression.concat(apply.parameters, this.parameters);
        }
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.function = this.function.simplify(context);
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = this.parameters[i].simplify(context);
            ++i;
        }
        this.combineApplications();
        if (this.function instanceof EConstant) {
            Expression simplified;
            EConstant constant = (EConstant)this.function;
            MacroRule rule = constant.value.getMacroRule();
            if (rule != null && (simplified = rule.apply(context, constant.typeParameters, this)) != null) {
                return simplified.simplify(context);
            }
        }
        return this;
    }

    @Override
    public String getPatternHead() throws NotPatternException {
        return this.function.getPatternHead();
    }

    @Override
    public LhsType getLhsType() throws NotPatternException {
        LhsType lhsType = this.function.getLhsType();
        if (lhsType instanceof PatternMatchingLhs) {
            Expression[] expressionArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                parameter.collectVariableNames((PatternMatchingLhs)lhsType);
                ++n2;
            }
        }
        return lhsType;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.function = this.function.resolve(context);
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = this.parameters[i].resolve(context);
            ++i;
        }
        this.combineApplications();
        return this;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        this.function = this.function.resolveAsPattern(context);
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = this.parameters[i].resolveAsPattern(context);
            ++i;
        }
        this.combineApplications();
        if (!(this.function instanceof EConstant) && !(this.function instanceof EError)) {
            context.getErrorLog().log(this.location, "Only constants can be applied in patterns.");
            return new EError();
        }
        return this;
    }

    @Override
    public void getParameters(TranslationContext context, ArrayList<Expression> parameters) {
        this.function.getParameters(context, parameters);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameters.add(parameter);
            ++n2;
        }
    }

    @Override
    public void removeFreeVariables(THashSet<Variable> vars) {
        this.function.removeFreeVariables(vars);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.removeFreeVariables(vars);
            ++n2;
        }
    }

    @Override
    public Expression replace(ReplaceContext context) {
        return new EApply(this.getLocation(), this.effect.replace(context.tvarMap), this.function.replace(context), EApply.replace(context, this.parameters));
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.function.setLocationDeep(loc);
            Expression[] expressionArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                parameter.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public int getFunctionDefinitionArity() throws NotPatternException {
        return this.function.getFunctionDefinitionArity() + this.parameters.length;
    }

    @Override
    public IExpression toIExpression(SCLValueCache valueCache) {
        return new IApply(this.function.toIExpression(valueCache), EApply.toIExpressions(valueCache, this.parameters));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Expression inferType(TypingContext context) {
        block6: {
            this.function = this.function.inferType(context);
            this.function = context.instantiate(this.function);
            try {
                mfun = Types.unifyFunction(this.function.getType(), this.parameters.length);
                break block6;
            }
            catch (UnificationException e) {
                arity = Types.getArity(this.function.getType());
                if (arity == 0) {
                    context.getErrorLog().log(this.location, "Application of non-function.");
                } else {
                    context.getErrorLog().log(this.location, "Function of arity " + arity + " is applied with " + this.parameters.length + " parameters.");
                }
                this.setType(Types.metaVar(Kinds.STAR));
                i = 0;
                ** while (i < this.parameters.length)
            }
lbl-1000:
            // 1 sources

            {
                this.parameters[i] = this.parameters[i].inferType(context);
                ++i;
                continue;
            }
lbl18:
            // 1 sources

            return this;
        }
        i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = this.parameters[i].checkType(context, mfun.parameterTypes[i]);
            ++i;
        }
        this.effect = mfun.effect;
        context.declareEffect(this.location, mfun.effect);
        this.setType(mfun.returnType);
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        if (decorator.decorateSubstructure(this)) {
            this.function = this.function.decorate(decorator);
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i] = this.parameters[i].decorate(decorator);
                ++i;
            }
        }
        return decorator.decorate(this);
    }

    public Type getLocalEffect() {
        return this.effect;
    }

    public Expression toANormalForm(Expression root) {
        Expression expression = root;
        int i = this.parameters.length - 1;
        while (i >= 0) {
            Expression parameter = this.parameters[i];
            if (parameter.isEffectful()) {
                Variable var = new Variable("aNormalTemp" + i, parameter.getType());
                expression = new ESimpleLet(var, parameter, expression);
                this.parameters[i] = new EVariable(var);
            }
            --i;
        }
        if (this.function.isEffectful()) {
            Variable var = new Variable("aNormalTempF", this.function.getType());
            expression = new ESimpleLet(var, this.function, expression);
            this.function = new EVariable(var);
        }
        return expression;
    }

    @Override
    public boolean isEffectful() {
        if (this.effect != Types.NO_EFFECTS) {
            return true;
        }
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            if (parameter.isEffectful()) {
                return true;
            }
            ++n2;
        }
        return this.function.isEffectful();
    }

    @Override
    public boolean isFunctionPattern() {
        return !this.isConstructorApplication();
    }

    @Override
    public boolean isConstructorApplication() {
        return this.function.isConstructorApplication();
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        effects.add((Object)this.effect);
        this.function.collectEffects(effects);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectEffects(effects);
            ++n2;
        }
    }

    @Override
    public void toString(PrintingContext context, int precedence) {
        if (precedence < 0) {
            context.append('(');
        }
        this.function.toString(context, precedence);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            context.append(' ');
            parameter.toString(context, precedence - 1);
            ++n2;
        }
        if (precedence < 0) {
            context.append(')');
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

