/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.contexts;

import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EIf;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.MultiFunction;

public class SimplificationContext
implements EnvironmentalContext {
    Environment environment;
    ErrorLog errorLog;
    public static final Name MAP_LIST = Name.create("Prelude", "mapList");
    public static final Name GUARD_LIST = Name.create("Prelude", "guardList");
    public static final Name CONCAT_MAP = Name.create("Prelude", "concatMap");
    public static final Name EMPTY_LIST = Name.create("Prelude", "emptyList");
    public static final Name SINGLETON_LIST = Name.create("Prelude", "singletonList");
    public static final Name APPEND_LIST = Name.create("Prelude", "appendList");
    public static final Name ADD_LIST = Name.create("Prelude", "addList");
    public static final Name FROM_INTEGER = Name.create("Prelude", "fromInteger");
    public static final Name FROM_DOUBLE = Name.create("Prelude", "fromDouble");
    THashMap<Name, SCLValue> constants = new THashMap();
    THashMap<Variable, Expression> inlinedVariables = new THashMap();
    TLongArrayList locatableStack = new TLongArrayList();
    long locatable;
    JavaTypeTranslator javaTypeTranslator;
    JavaReferenceValidator<?, ?, ?, ?> validator;
    Variable[] context = Variable.EMPTY_ARRAY;

    public SimplificationContext(Environment environment, ErrorLog errorLog, JavaTypeTranslator javaTypeTranslator, JavaReferenceValidator<?, ?, ?, ?> validator) {
        this.environment = environment;
        this.errorLog = errorLog;
        this.javaTypeTranslator = javaTypeTranslator;
        this.validator = validator;
    }

    public void setContextParameters(Variable[] context) {
        this.context = context;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public void pushLocation(long loc) {
        this.locatableStack.add(this.locatable);
        this.locatable = loc;
    }

    public void popLocation() {
        this.locatable = this.locatableStack.removeAt(this.locatableStack.size() - 1);
    }

    @Override
    public SCLValue getSCLValue(Name name) {
        if (this.constants.containsKey((Object)name)) {
            return (SCLValue)this.constants.get((Object)name);
        }
        SCLValue value = this.environment.getValue(name);
        if (value == null) {
            this.errorLog.log(this.locatable, "Couldn't find " + name + ".");
        }
        this.constants.put((Object)name, (Object)value);
        return value;
    }

    public Expression getConstant(Name name, Type ... typeParameters) {
        SCLValue value = this.getSCLValue(name);
        if (value == null) {
            return new EError(this.locatable);
        }
        return new EConstant(value, typeParameters);
    }

    public Expression apply(Expression f, Expression ... ps) {
        Expression result = f;
        Type type = f.getType();
        Expression[] expressionArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            MultiFunction mfun;
            Expression p = expressionArray[n2];
            result = new EApply(this.locatable, result, p);
            try {
                mfun = Types.matchFunction(type, 1);
            }
            catch (MatchException e) {
                throw new InternalCompilerError(e);
            }
            type = mfun.returnType;
            result.setType(type);
            ++n2;
        }
        return result;
    }

    public Expression tuple(Expression ... cs) {
        if (cs.length == 1) {
            return cs[0];
        }
        Type[] typeParameters = new Type[cs.length];
        int i = 0;
        while (i < cs.length) {
            typeParameters[i] = cs[i].getType();
            ++i;
        }
        Expression result = new EConstant(this.locatable, Builtins.TUPLE_CONSTRUCTORS[cs.length], typeParameters);
        Expression[] expressionArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Expression c = expressionArray[n2];
            result = new EApply(this.locatable, result, c);
            ++n2;
        }
        result.setType(Types.tuple(Types.getTypes(cs)));
        return result;
    }

    public Expression var(Variable var) {
        EVariable result = new EVariable(this.locatable, var);
        result.setType(var.getType());
        return result;
    }

    public Expression simpleLambda(Variable var, Expression val) {
        ESimpleLambda result = new ESimpleLambda(var, val);
        result.setType(Types.function(var.getType(), val.getType()));
        return result;
    }

    public Expression lambda(Expression pat, Expression val) {
        return new ELambda(this.locatable, pat, val);
    }

    public Expression lambda(Case ... cases) {
        return new ELambda(this.locatable, cases);
    }

    public Expression if_(Expression condition, Expression then_, Expression else_) {
        return new EIf(this.locatable, condition, then_, else_);
    }

    public Expression mapList(Expression f, Expression l) {
        try {
            MultiFunction mfun = Types.matchFunction(f.getType(), 1);
            return this.apply(this.getConstant(MAP_LIST, mfun.parameterTypes[0], mfun.returnType), f, l);
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }

    public Expression guardList(Expression cond) {
        return this.apply(this.getConstant(GUARD_LIST, new Type[0]), cond);
    }

    public Expression concatMap(Expression f, Expression l) {
        try {
            MultiFunction mfun = Types.matchFunction(f.getType(), 1);
            return this.apply(this.getConstant(CONCAT_MAP, mfun.parameterTypes[0], mfun.effect, Types.matchApply(Types.LIST, mfun.returnType)), f, l);
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }

    public Expression emptyList(Type type) {
        return this.getConstant(EMPTY_LIST, type);
    }

    public Expression singletonList(Expression e) {
        return this.apply(this.getConstant(SINGLETON_LIST, e.getType()), e);
    }

    public Expression match(Expression scrutinee, Expression pattern, Expression value) {
        Case case_ = new Case(pattern, value);
        return new EMatch(scrutinee, case_);
    }

    public Expression match(Expression scrutinee, Case ... cases) {
        return new EMatch(scrutinee, cases);
    }

    public Expression literal(Constant constant) {
        return new ELiteral(constant);
    }

    public JavaReferenceValidator<Object, Object, Object, Object> getJavaReferenceValidator() {
        return this.validator;
    }

    public JavaTypeTranslator getJavaTypeTranslator() {
        return this.javaTypeTranslator;
    }

    public void addInlinedVariable(Variable variable, Expression value) {
        this.inlinedVariables.put((Object)variable, (Object)value);
    }

    public Expression getInlinedValue(Variable variable) {
        return (Expression)this.inlinedVariables.get((Object)variable);
    }

    public Expression getContextParameter(int id) {
        return this.var(this.context[id]);
    }

    public EVariable blank() {
        return new EVariable(new Variable("_"));
    }

    public Expression conditionalExecution(Expression condition, Expression continuation) {
        return new EIf(condition, continuation, new EConstant(Builtins.TUPLE_CONSTRUCTORS[0]));
    }

    public Expression iteratedExecution(Expression list, Variable variable, Expression continuation) {
        return new EApply(9223372034707292160L, Types.PROC, this.getConstant(Name.create("Prelude", "iterList"), variable.getType(), Types.PROC, Types.tupleConstructor(0)), new ESimpleLambda(Types.PROC, variable, continuation), list);
    }

    public Expression iteratedVectorExecution(EApply vector, Variable variable, Expression continuation) {
        return new EApply(9223372034707292160L, Types.PROC, this.getConstant(Name.create("Vector", "iterVector"), variable.getType(), Types.PROC, Types.tupleConstructor(0)), new ESimpleLambda(Types.PROC, variable, continuation), vector);
    }

    public Expression[] vars(Variable[] parameters) {
        Expression[] result = new Expression[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            result[i] = new EVariable(parameters[i]);
            ++i;
        }
        return result;
    }
}

