/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.constraints;

import gnu.trove.map.hash.THashMap;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.values.ClassConstant;
import org.simantics.scl.compiler.codegen.values.JavaConstructor;
import org.simantics.scl.compiler.codegen.values.JavaStaticField;
import org.simantics.scl.compiler.codegen.values.StringConstant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.constraints.Reduction;
import org.simantics.scl.compiler.elaboration.constraints.Superconstraint;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.types.TApply;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TFun;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TUnion;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class ConstraintEnvironment {
    Environment environment;
    private static final Type SERIALIZABLE_BOOLEAN = Types.pred(Types.SERIALIZABLE, Types.BOOLEAN);
    private static final Type SERIALIZABLE_BYTE = Types.pred(Types.SERIALIZABLE, Types.BYTE);
    private static final Type SERIALIZABLE_SHORT = Types.pred(Types.SERIALIZABLE, Types.SHORT);
    private static final Type SERIALIZABLE_INTEGER = Types.pred(Types.SERIALIZABLE, Types.INTEGER);
    private static final Type SERIALIZABLE_LONG = Types.pred(Types.SERIALIZABLE, Types.LONG);
    private static final Type SERIALIZABLE_FLOAT = Types.pred(Types.SERIALIZABLE, Types.FLOAT);
    private static final Type SERIALIZABLE_DOUBLE = Types.pred(Types.SERIALIZABLE, Types.DOUBLE);
    private static final Type SERIALIZABLE_STRING = Types.pred(Types.SERIALIZABLE, Types.STRING);
    private static final Type SERIALIZABLE_BOOLEAN_ARRAY = Types.pred(Types.SERIALIZABLE, Types.BOOLEAN_ARRAY);
    private static final Type SERIALIZABLE_BYTE_ARRAY = Types.pred(Types.SERIALIZABLE, Types.BYTE_ARRAY);
    private static final Type SERIALIZABLE_SHORT_ARRAY = Types.pred(Types.SERIALIZABLE, Types.SHORT_ARRAY);
    private static final Type SERIALIZABLE_INTEGER_ARRAY = Types.pred(Types.SERIALIZABLE, Types.INTEGER_ARRAY);
    private static final Type SERIALIZABLE_LONG_ARRAY = Types.pred(Types.SERIALIZABLE, Types.LONG_ARRAY);
    private static final Type SERIALIZABLE_FLOAT_ARRAY = Types.pred(Types.SERIALIZABLE, Types.FLOAT_ARRAY);
    private static final Type SERIALIZABLE_DOUBLE_ARRAY = Types.pred(Types.SERIALIZABLE, Types.DOUBLE_ARRAY);
    private static final Type SERIALIZABLE_TUPLE0 = Types.pred(Types.SERIALIZABLE, Types.tuple(new Type[0]));

    public ConstraintEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Superconstraint[] getSuperconstraints(TPred constraint) {
        TypeClass tc = this.environment.getTypeClass(constraint.typeClass);
        if (tc == null) {
            throw new InternalCompilerError("Didn't find constraint " + constraint + ". Maybe Prelude is not loaded?");
        }
        if (tc.context.length == 0) {
            return Superconstraint.EMPTY_ARRAY;
        }
        Superconstraint[] result = new Superconstraint[tc.context.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new Superconstraint((TPred)tc.context[i].replace(tc.parameters, constraint.parameters), tc.superGenerators[i]);
            ++i;
        }
        return result;
    }

    public Reduction reduce(TPred constraint) {
        Type parameter;
        if (constraint.typeClass == Types.VEC_COMP && (parameter = Types.canonical(constraint.parameters[0])).isGround()) {
            return new Reduction(new ELiteral(new ClassConstant(Types.pred(Types.VEC_COMP, parameter), parameter)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
        }
        if (constraint.typeClass == Types.SERIALIZABLE) {
            parameter = Types.canonical(constraint.parameters[0]);
            if (parameter instanceof TCon) {
                TCon con = (TCon)parameter;
                if (con == Types.DOUBLE) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "DOUBLE", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.DoubleBinding"), SERIALIZABLE_DOUBLE)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.STRING) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "STRING", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.StringBinding"), SERIALIZABLE_STRING)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.INTEGER) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "INTEGER", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.IntegerBinding"), SERIALIZABLE_INTEGER)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.BOOLEAN) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "BOOLEAN", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.BooleanBinding"), SERIALIZABLE_BOOLEAN)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.BYTE) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "BYTE", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.ByteBinding"), SERIALIZABLE_BYTE)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.FLOAT) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "FLOAT", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.FloatBinding"), SERIALIZABLE_FLOAT)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.LONG) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "LONG", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.LongBinding"), SERIALIZABLE_LONG)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.tupleConstructor(0)) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "VOID", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.Binding"), SERIALIZABLE_TUPLE0)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.DOUBLE_ARRAY) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "DOUBLE_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.ArrayBinding"), SERIALIZABLE_DOUBLE_ARRAY)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.INTEGER_ARRAY) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "INTEGER_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.ArrayBinding"), SERIALIZABLE_INTEGER_ARRAY)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.BOOLEAN_ARRAY) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "BOOLEAN_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.ArrayBinding"), SERIALIZABLE_BOOLEAN_ARRAY)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.BYTE_ARRAY) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "BYTE_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.ArrayBinding"), SERIALIZABLE_BYTE_ARRAY)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.FLOAT_ARRAY) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "FLOAT_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.ArrayBinding"), SERIALIZABLE_FLOAT_ARRAY)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (con == Types.LONG_ARRAY) {
                    return new Reduction(new ELiteral(new JavaStaticField("org.simantics.databoard.Bindings", "LONG_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass((String)"org.simantics.databoard.binding.ArrayBinding"), SERIALIZABLE_LONG_ARRAY)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
            } else if (parameter instanceof TApply) {
                TApply apply1 = (TApply)parameter;
                Type f1 = Types.canonical(apply1.function);
                Type p1 = Types.canonical(apply1.parameter);
                if (f1 instanceof TCon) {
                    TCon con = (TCon)f1;
                    if (con == Types.LIST) {
                        return new Reduction(new ELiteral(new JavaConstructor("org.simantics.databoard.binding.impl.ArrayListBinding", (Type)Types.NO_EFFECTS, (Type)Types.pred(Types.SERIALIZABLE, Types.list(p1)), Types.pred(Types.SERIALIZABLE, p1))), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.SERIALIZABLE, p1)});
                    }
                    if (con == Types.MAYBE) {
                        return new Reduction(new ELiteral(new JavaConstructor("org.simantics.databoard.binding.impl.OptionalBindingDefault", (Type)Types.NO_EFFECTS, (Type)Types.pred(Types.SERIALIZABLE, Types.apply((Type)Types.MAYBE, p1)), Types.pred(Types.SERIALIZABLE, p1))), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.SERIALIZABLE, p1)});
                    }
                } else if (f1 instanceof TApply) {
                    TApply apply2 = (TApply)parameter;
                    Type f2 = Types.canonical(apply2.function);
                    Type p2 = Types.canonical(apply2.parameter);
                    if (f2 instanceof TCon) {
                        TCon tCon = (TCon)f2;
                    }
                }
            }
        } else if (constraint.typeClass == Types.TYPEABLE) {
            parameter = Types.canonical(constraint.parameters[0]);
            if (parameter instanceof TCon) {
                TCon con = (TCon)parameter;
                return new Reduction(new EApply(9223372034707292160L, (Expression)new EConstant(Builtins.INSTANCE.getValue("TCon")), new ELiteral(new StringConstant(con.module)), new ELiteral(new StringConstant(con.name))), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
            }
            if (parameter instanceof TApply) {
                TApply apply = (TApply)parameter;
                return new Reduction(new EConstant(Builtins.INSTANCE.getValue("TApply")), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.TYPEABLE, apply.function), Types.pred(Types.TYPEABLE, apply.parameter)});
            }
            if (parameter instanceof TFun) {
                TFun fun = (TFun)parameter;
                return new Reduction(new EConstant(Builtins.INSTANCE.getValue("TFun")), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.TYPEABLE, fun.domain), Types.pred(Types.TYPEABLE, fun.range)});
            }
            if (parameter instanceof TUnion) {
                TUnion union = (TUnion)parameter;
                return new Reduction(new EApply((Expression)new EConstant(Builtins.INSTANCE.getValue("TCon")), (Expression)new ELiteral(new StringConstant(union.toString()))), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
            }
        }
        THashMap substitution = new THashMap();
        for (TypeClassInstance inst : this.environment.getInstances(constraint.typeClass)) {
            if (Types.match(inst.instance, constraint, (THashMap<TVar, Type>)substitution)) {
                TPred[] demands = new TPred[inst.context.length];
                int i = 0;
                while (i < demands.length) {
                    demands[i] = (TPred)inst.context[i].replace((THashMap<TVar, Type>)substitution);
                    ++i;
                }
                Type[] parameters = new Type[inst.generatorParameters.length];
                int i2 = 0;
                while (i2 < parameters.length) {
                    Type parameter2 = (Type)substitution.get((Object)inst.generatorParameters[i2]);
                    if (parameter2 == null) {
                        parameter2 = inst.generatorParameters[i2];
                    }
                    parameters[i2] = parameter2;
                    ++i2;
                }
                return new Reduction(new ELiteral(inst.generator), parameters, demands);
            }
            substitution.clear();
        }
        return null;
    }
}

