/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.common.stateful;

import gnu.trove.map.hash.TObjectLongHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Creates;
import org.simantics.scl.compiler.common.stateful.InvalidStateException;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.common.stateful.StateValidator;

public class State {
    private HashMap<String, Object> state = new HashMap();
    private StateValidator validator;
    public static final TObjectLongHashMap<String> TIMINGS = new TObjectLongHashMap();

    public void run(CompilationPhase phase) throws InvalidStateException {
        Object value;
        String name;
        Annotation ann;
        Field field;
        Class<?> clazz = phase.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            ann = field.getAnnotation(Requires.class);
            if (ann != null) {
                name = field.getName();
                Object object = value = ann.consumes() ? this.state.remove(name) : this.state.get(name);
                if (value == null) {
                    throw new InternalCompilerError("Couldn't run " + phase + " because " + name + " was not defined.");
                }
                try {
                    field.set(phase, value);
                }
                catch (IllegalArgumentException e) {
                    if (!field.getType().isAssignableFrom(value.getClass())) {
                        throw new InternalCompilerError(phase + " required " + name + " of type " + field.getType() + " but " + "defined value had type " + value.getClass() + ".");
                    }
                    throw new InternalCompilerError(e);
                }
                catch (IllegalAccessException e) {
                    throw new InternalCompilerError(e);
                }
            }
            ++n2;
        }
        try {
            phase.run();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new InternalCompilerError(e);
        }
        fieldArray = clazz.getFields();
        n = fieldArray.length;
        n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            ann = field.getAnnotation(Creates.class);
            if (ann != null) {
                name = field.getName();
                if (this.state.containsKey(name)) {
                    throw new IllegalArgumentException(phase + " tried to " + "redefine " + name);
                }
                try {
                    value = field.get(phase);
                    this.state.put(name, value);
                }
                catch (IllegalArgumentException e) {
                    throw new InternalCompilerError(e);
                }
                catch (IllegalAccessException e) {
                    throw new InternalCompilerError(e);
                }
            }
            ++n2;
        }
        if (this.validator != null) {
            this.validator.checkValidity(this);
        }
    }

    public <T> T get(String name) {
        return (T)this.state.get(name);
    }

    public <T> void set(String name, T value) {
        this.state.put(name, value);
    }

    public void setValidator(StateValidator validator) {
        this.validator = validator;
    }
}

