/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.common.errors;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.simantics.scl.compiler.common.errors.SCLError;

public class ErrorLog {
    ArrayList<SCLError> errors = new ArrayList();
    long exceptionPosition;

    public void log(String message) {
        this.errors.add(new SCLError(message));
    }

    public void log(SCLError error) {
        this.errors.add(error);
    }

    public void log(long locatable, String description) {
        this.log(new SCLError(locatable, description));
    }

    public void log(Exception e) {
        this.log(new SCLError(ErrorLog.exceptionToString(e)));
    }

    public void log(long locatable, Exception e) {
        this.log(new SCLError(locatable, ErrorLog.exceptionToString(e)));
    }

    private static String exceptionToString(Exception e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        return w.toString();
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public SCLError[] getErrors() {
        Collections.sort(this.errors);
        return this.errors.toArray(new SCLError[this.errors.size()]);
    }

    public void setExceptionPosition(long exceptionPosition) {
        if (this.exceptionPosition == 9223372034707292160L) {
            this.exceptionPosition = exceptionPosition;
        }
    }

    public long getExceptionPosition() {
        return this.exceptionPosition;
    }

    public String getErrorsAsString() {
        StringBuilder b = new StringBuilder();
        for (SCLError error : this.errors) {
            b.append(error.description).append('\n');
        }
        return b.toString();
    }
}

