/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.writer;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.scl.compiler.codegen.classes.InterfaceDescription;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.SSAModule;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.codegen.values.JavaStaticField;
import org.simantics.scl.compiler.codegen.values.SCLConstant;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;

public class ModuleWriter {
    SSAModule module;
    String moduleClassName;
    THashMap<Tuple2, JavaStaticField> externalConstantMap = new THashMap();
    int externalConstantId = 0;

    public ModuleWriter(String moduleClassName, InterfaceDescription interfaceDescription) {
        this.module = new SSAModule(interfaceDescription);
        this.moduleClassName = moduleClassName;
    }

    public CodeWriter createFunction(SCLConstant constant, TVar[] typeParameters, Type effect, Type returnType, Type[] parameterTypes) {
        Name name = constant.getName();
        SSAFunction function = new SSAFunction(typeParameters, effect, returnType);
        SSABlock block = new SSABlock(parameterTypes);
        function.addBlock(block);
        function.setTarget(constant);
        constant.setDefinition(function);
        this.module.put(name, constant);
        return new CodeWriter(this, block);
    }

    public String toString() {
        return this.module.toString();
    }

    public SSAModule getModule() {
        return this.module;
    }

    public Constant getExternalConstant(Object value, Type type) {
        Tuple2 tuple = new Tuple2(value, (Object)type);
        if (this.externalConstantMap.contains((Object)tuple)) {
            return (Constant)this.externalConstantMap.get((Object)tuple);
        }
        ++this.externalConstantId;
        String name = "externalConstant" + this.externalConstantId;
        JavaStaticField constant = new JavaStaticField(this.moduleClassName, name, type);
        this.externalConstantMap.put((Object)tuple, (Object)constant);
        this.module.addStaticField(new Tuple2((Object)name, (Object)type));
        return constant;
    }

    public Tuple2[] getExternalConstants() {
        Tuple2[] result = new Tuple2[this.externalConstantMap.size()];
        int i = 0;
        for (Map.Entry entry : this.externalConstantMap.entrySet()) {
            result[i++] = new Tuple2((Object)((JavaStaticField)entry.getValue()).getFieldName(), ((Tuple2)entry.getKey()).c0);
        }
        return result;
    }
}

