/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.writer;

import org.simantics.scl.compiler.codegen.continuations.Branch;
import org.simantics.scl.compiler.codegen.continuations.BranchRef;
import org.simantics.scl.compiler.codegen.continuations.ICont;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.exits.If;
import org.simantics.scl.compiler.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.codegen.ssa.exits.Switch;
import org.simantics.scl.compiler.codegen.ssa.exits.Throw;
import org.simantics.scl.compiler.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.codegen.ssa.statements.LetFunctions;
import org.simantics.scl.compiler.codegen.writer.ModuleWriter;
import org.simantics.scl.compiler.codegen.writer.RecursiveDefinitionWriter;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.MultiFunction;

public class CodeWriter {
    ModuleWriter moduleWriter;
    SSABlock block;

    CodeWriter(ModuleWriter moduleWriter, SSABlock block) {
        this.moduleWriter = moduleWriter;
        this.block = block;
    }

    public IVal apply(int lineNumber, IVal function, IVal ... parameters) {
        try {
            MultiFunction mfun = Types.matchFunction(function.getType(), parameters.length);
            return this.applyWithEffect(lineNumber, mfun.effect, mfun.returnType, function, parameters);
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }

    public IVal applyWithEffectChecked(int lineNumber, Type effect, Type returnType, IVal function, IVal ... parameters) {
        try {
            MultiFunction mfun = Types.matchFunction(function.getType(), parameters.length);
            if (!Types.equals(effect, mfun.effect)) {
                throw new InternalCompilerError();
            }
            if (!Types.equals(returnType, mfun.returnType)) {
                throw new InternalCompilerError();
            }
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
        return this.applyWithEffect(lineNumber, effect, returnType, function, parameters);
    }

    public IVal applyWithEffect(long location, Type effect, Type returnType, IVal function, IVal ... parameters) {
        BoundVar var = new BoundVar(returnType);
        LetApply apply = new LetApply(var, effect, function.createOccurrence(), ValRef.createOccurrences(parameters));
        apply.location = location;
        this.block.addStatement(apply);
        return var;
    }

    public CodeWriter createBlock(Type ... parameterTypes) {
        SSABlock newBlock = new SSABlock(parameterTypes);
        this.block.getParent().addBlock(newBlock);
        return new CodeWriter(this.moduleWriter, newBlock);
    }

    public CodeWriter createFunction(TVar[] typeParameters, Type effect, Type returnType, Type[] parameterTypes) {
        SSAFunction function = new SSAFunction(typeParameters, effect, returnType);
        SSABlock block = new SSABlock(parameterTypes);
        function.addBlock(block);
        BoundVar target = new BoundVar(function.getType());
        function.setTarget(target);
        this.block.addStatement(new LetFunctions(function));
        return new CodeWriter(this.moduleWriter, block);
    }

    public RecursiveDefinitionWriter createRecursiveDefinition() {
        LetFunctions let = new LetFunctions();
        this.block.addStatement(let);
        return new RecursiveDefinitionWriter(this.moduleWriter, let);
    }

    public void continueAs(CodeWriter codeWriter) {
        this.block = codeWriter.block;
        codeWriter.block = null;
    }

    public IVal[] getParameters() {
        return this.block.getParameters();
    }

    public ICont getContinuation() {
        return this.block;
    }

    public void jump(ICont cont, IVal ... parameters) {
        this.block.setExit(new Jump(cont.createOccurrence(), ValRef.createOccurrences(parameters)));
        this.block = null;
    }

    public void if_(IVal condition, ICont thenTarget, ICont elseTarget) {
        this.block.setExit(new If(condition.createOccurrence(), thenTarget.createOccurrence(), elseTarget.createOccurrence()));
        this.block = null;
    }

    public void return_(IVal val) {
        this.jump(this.block.getParent().getReturnCont(), val);
    }

    public void switch_(IVal val, Branch[] branches) {
        this.block.setExit(new Switch(val.createOccurrence(), BranchRef.toBranchRefs(branches)));
        this.block = null;
    }

    public void throw_(long location) {
        Throw exit = new Throw();
        exit.location = location;
        this.block.setExit(exit);
        this.block = null;
    }

    public ModuleWriter getModuleWriter() {
        return this.moduleWriter;
    }

    public SSAFunction getFunction() {
        return this.block.getParent();
    }
}

