/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values.generic;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.PreparationStep;
import org.simantics.scl.compiler.codegen.utils.SCLContextPreparationStep;
import org.simantics.scl.compiler.codegen.values.generic.StackItem;

public class ThreadLocalStackItem
implements StackItem,
PreparationStep<LocalVariable> {
    private static final TypeDesc THREAD_LOCAL = TypeDesc.forClass(ThreadLocal.class);
    String variableName;
    TypeDesc type;

    public ThreadLocalStackItem(String variableName, TypeDesc type) {
        this.variableName = variableName;
        this.type = type;
    }

    @Override
    public void push(MethodBuilder mb, Val[] parameters) {
        mb.getCodeBuilder().loadLocal(mb.getPreparation(this));
    }

    @Override
    public void prepare(MethodBuilder mb) {
        LocalVariable var = mb.getPreparation(this);
        if (var == null) {
            CodeBuilder b = mb.getCodeBuilder();
            var = b.createLocalVariable("context", this.type);
            LocalVariable sclContext = SCLContextPreparationStep.getCurrent(mb);
            b.loadLocal(sclContext);
            b.loadConstant(this.variableName);
            b.invokeVirtual("gnu.trove.map.hash.THashMap", "get", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT});
            b.checkCast(this.type);
            b.storeLocal(var);
            mb.addPreparation(this, var);
        }
    }

    public int hashCode() {
        return 234234 + this.type.hashCode() + 31 * this.variableName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadLocalStackItem other = (ThreadLocalStackItem)obj;
        return this.variableName.equals(other.variableName) && this.type.equals((Object)other.type);
    }
}

