/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values.generic;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.generic.ClassRef;
import org.simantics.scl.compiler.codegen.values.generic.StackItem;

public interface MethodRef {
    public void invoke(MethodBuilder var1, StackItem[] var2, Val[] var3);

    public TypeDesc[] getParameterTypes();

    public TypeDesc getReturnType();

    public String getName();

    public static class ConstructorRef
    implements MethodRef {
        String className;
        TypeDesc[] params;
        TypeDesc ret;

        public ConstructorRef(String className, TypeDesc[] params) {
            this.className = className;
            this.params = params;
            this.ret = TypeDesc.forClass((String)className);
        }

        @Override
        public void invoke(MethodBuilder mb, StackItem[] stackItems, Val[] parameters) {
            CodeBuilder b = mb.getCodeBuilder();
            b.newObject(this.ret);
            b.dup();
            StackItem[] stackItemArray = stackItems;
            int n = stackItems.length;
            int n2 = 0;
            while (n2 < n) {
                StackItem stackItem = stackItemArray[n2];
                stackItem.push(mb, parameters);
                ++n2;
            }
            b.invokeConstructor(this.className, this.params);
        }

        @Override
        public TypeDesc[] getParameterTypes() {
            return this.params;
        }

        @Override
        public TypeDesc getReturnType() {
            return this.ret;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("public ");
            b.append(this.className);
            b.append("(");
            boolean first = true;
            TypeDesc[] typeDescArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDesc param = typeDescArray[n2];
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(param.getFullName());
                ++n2;
            }
            b.append(")");
            return b.toString();
        }

        @Override
        public String getName() {
            return String.valueOf(this.className) + ".<init>";
        }
    }

    public static class FieldRef
    implements MethodRef {
        String className;
        String fieldName;
        TypeDesc[] params;
        TypeDesc ret;

        public FieldRef(String className, String fieldName, TypeDesc ret) {
            this.className = className;
            this.fieldName = fieldName;
            this.ret = ret;
            this.params = new TypeDesc[]{TypeDesc.forClass((String)className)};
        }

        @Override
        public void invoke(MethodBuilder mb, StackItem[] stackItems, Val[] parameters) {
            stackItems[0].push(mb, parameters);
            mb.getCodeBuilder().loadField(this.className, this.fieldName, this.ret);
        }

        @Override
        public TypeDesc[] getParameterTypes() {
            return this.params;
        }

        @Override
        public TypeDesc getReturnType() {
            return this.ret;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("public ");
            b.append(this.ret.getFullName());
            b.append(" ");
            b.append(this.fieldName);
            return b.toString();
        }

        @Override
        public String getName() {
            return String.valueOf(this.className) + "." + this.fieldName;
        }
    }

    public static class ObjectMethodRef
    implements MethodRef {
        boolean isInterface;
        String className;
        String methodName;
        TypeDesc ret;
        TypeDesc[] params;
        TypeDesc[] realParams;

        public ObjectMethodRef(boolean isInterface, String className, String methodName, TypeDesc ret, TypeDesc[] params) {
            this.isInterface = isInterface;
            this.className = className;
            this.methodName = methodName;
            this.ret = ret;
            this.params = params;
            this.realParams = new TypeDesc[params.length + 1];
            this.realParams[0] = TypeDesc.forClass((String)className);
            int i = 0;
            while (i < params.length) {
                this.realParams[i + 1] = params[i];
                ++i;
            }
        }

        @Override
        public void invoke(MethodBuilder mb, StackItem[] stackItems, Val[] parameters) {
            StackItem[] stackItemArray = stackItems;
            int n = stackItems.length;
            int n2 = 0;
            while (n2 < n) {
                StackItem stackItem = stackItemArray[n2];
                stackItem.push(mb, parameters);
                ++n2;
            }
            if (this.isInterface) {
                mb.getCodeBuilder().invokeInterface(this.className, this.methodName, this.ret, this.params);
            } else {
                mb.getCodeBuilder().invokeVirtual(this.className, this.methodName, this.ret, this.params);
            }
        }

        @Override
        public TypeDesc[] getParameterTypes() {
            return this.realParams;
        }

        @Override
        public TypeDesc getReturnType() {
            return this.ret;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("public ");
            b.append(this.ret.getFullName());
            b.append(" ");
            b.append(this.methodName);
            b.append("(");
            boolean first = true;
            TypeDesc[] typeDescArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDesc param = typeDescArray[n2];
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(param.getFullName());
                ++n2;
            }
            b.append(")");
            return b.toString();
        }

        @Override
        public String getName() {
            return String.valueOf(this.className) + "." + this.methodName;
        }
    }

    public static class SetFieldRef
    implements MethodRef {
        String className;
        String fieldName;
        TypeDesc ret;
        TypeDesc[] params;

        public SetFieldRef(String className, String fieldName, TypeDesc ret) {
            this.className = className;
            this.fieldName = fieldName;
            this.ret = ret;
            this.params = new TypeDesc[]{TypeDesc.forClass((String)className), ret};
        }

        @Override
        public void invoke(MethodBuilder mb, StackItem[] stackItems, Val[] parameters) {
            stackItems[0].push(mb, parameters);
            stackItems[1].push(mb, parameters);
            mb.getCodeBuilder().storeField(this.className, this.fieldName, this.ret);
        }

        @Override
        public TypeDesc[] getParameterTypes() {
            return this.params;
        }

        @Override
        public TypeDesc getReturnType() {
            return TypeDesc.VOID;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("public ");
            b.append(this.ret.getFullName());
            b.append(" ");
            b.append(this.fieldName);
            return b.toString();
        }

        @Override
        public String getName() {
            return String.valueOf(this.className) + ".<set>" + this.fieldName;
        }
    }

    public static class SetStaticFieldRef
    implements MethodRef {
        String className;
        String fieldName;
        TypeDesc ret;
        TypeDesc[] params;

        public SetStaticFieldRef(String className, String fieldName, TypeDesc ret) {
            this.className = className;
            this.fieldName = fieldName;
            this.ret = ret;
            this.params = new TypeDesc[]{ret};
        }

        @Override
        public void invoke(MethodBuilder mb, StackItem[] stackItems, Val[] parameters) {
            stackItems[0].push(mb, parameters);
            mb.getCodeBuilder().storeStaticField(this.className, this.fieldName, this.ret);
        }

        @Override
        public TypeDesc[] getParameterTypes() {
            return this.params;
        }

        @Override
        public TypeDesc getReturnType() {
            return TypeDesc.VOID;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("public static ");
            b.append(this.ret.getFullName());
            b.append(" ");
            b.append(this.fieldName);
            return b.toString();
        }

        @Override
        public String getName() {
            return String.valueOf(this.className) + ".<set>" + this.fieldName;
        }
    }

    public static class StaticFieldRef
    implements MethodRef {
        String className;
        String fieldName;
        TypeDesc ret;

        public StaticFieldRef(String className, String fieldName, TypeDesc ret) {
            this.className = className;
            this.fieldName = fieldName;
            this.ret = ret;
        }

        @Override
        public void invoke(MethodBuilder mb, StackItem[] stackItems, Val[] parameters) {
            mb.getCodeBuilder().loadStaticField(this.className, this.fieldName, this.ret);
        }

        @Override
        public TypeDesc[] getParameterTypes() {
            return ClassRef.NO_PARAMS;
        }

        @Override
        public TypeDesc getReturnType() {
            return this.ret;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("public static ");
            b.append(this.ret.getFullName());
            b.append(" ");
            b.append(this.fieldName);
            return b.toString();
        }

        @Override
        public String getName() {
            return String.valueOf(this.className) + "." + this.fieldName;
        }
    }

    public static class StaticMethodRef
    implements MethodRef {
        String className;
        String methodName;
        TypeDesc ret;
        TypeDesc[] params;

        public StaticMethodRef(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
            this.className = className;
            this.methodName = methodName;
            this.ret = ret;
            this.params = params;
        }

        @Override
        public void invoke(MethodBuilder mb, StackItem[] stackItems, Val[] parameters) {
            StackItem[] stackItemArray = stackItems;
            int n = stackItems.length;
            int n2 = 0;
            while (n2 < n) {
                StackItem stackItem = stackItemArray[n2];
                stackItem.push(mb, parameters);
                ++n2;
            }
            mb.getCodeBuilder().invokeStatic(this.className, this.methodName, this.ret, this.params);
        }

        @Override
        public TypeDesc[] getParameterTypes() {
            return this.params;
        }

        @Override
        public TypeDesc getReturnType() {
            return this.ret;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("public static ");
            b.append(this.ret.getFullName());
            b.append(" ");
            b.append(this.methodName);
            b.append("(");
            boolean first = true;
            TypeDesc[] typeDescArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDesc param = typeDescArray[n2];
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(param.getFullName());
                ++n2;
            }
            b.append(")");
            return b.toString();
        }

        @Override
        public String getName() {
            return String.valueOf(this.className) + "." + this.methodName;
        }
    }
}

