/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values.generic;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.compiler.codegen.values.generic.MethodRef;
import org.simantics.scl.compiler.codegen.values.generic.OutputFilter;
import org.simantics.scl.compiler.codegen.values.generic.StackItem;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;

public class CallJava
extends FunctionValue {
    StackItem[] stackItems;
    MethodRef methodRef;
    OutputFilter filter;
    public static final int INCOMPARABLE = -2;
    public static final int LESS = -1;
    public static final int EQUAL = 0;
    public static final int GREATER = 1;

    public CallJava(TVar[] typeParameters, Type effect, Type returnType, Type[] parameterTypes, StackItem[] stackItems, MethodRef methodRef, OutputFilter filter) {
        super(typeParameters, effect, returnType, parameterTypes);
        this.stackItems = stackItems;
        this.methodRef = methodRef;
        this.filter = filter;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        this.methodRef.invoke(mb, this.stackItems, parameters);
        if (this.filter != null) {
            this.filter.filter(mb);
        }
        return this.getReturnType();
    }

    public MethodRef getMethodRef() {
        return this.methodRef;
    }

    public String toString() {
        return this.methodRef.getName();
    }

    public int compareTo(JavaReferenceValidator validator, CallJava other) {
        TypeDesc[] ps2;
        MethodRef m1 = this.methodRef;
        MethodRef m2 = other.methodRef;
        TypeDesc[] ps1 = m1.getParameterTypes();
        if (ps1.length != (ps2 = m2.getParameterTypes()).length) {
            return -2;
        }
        boolean lessOrEqual = true;
        boolean greaterOrEqual = true;
        int i = 0;
        while (i < ps1.length) {
            if (!ps1[i].equals((Object)ps2[i])) {
                if (!validator.isAssignableFrom(ps1[i], ps2[i])) {
                    lessOrEqual = false;
                }
                if (!validator.isAssignableFrom(ps2[i], ps1[i])) {
                    greaterOrEqual = false;
                }
            }
            ++i;
        }
        if (lessOrEqual) {
            if (greaterOrEqual) {
                return 0;
            }
            return -1;
        }
        if (greaterOrEqual) {
            return 1;
        }
        return -2;
    }

    @Override
    public void prepare(MethodBuilder mb) {
        StackItem[] stackItemArray = this.stackItems;
        int n = this.stackItems.length;
        int n2 = 0;
        while (n2 < n) {
            StackItem item = stackItemArray[n2];
            item.prepare(mb);
            ++n2;
        }
    }
}

