/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.types.Types;

public class StringConstant
extends Constant {
    String value;

    public StringConstant(String value) {
        super(Types.STRING);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.getCodeBuilder().loadConstant(this.value);
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringConstant other = (StringConstant)obj;
        return this.value.equals(other.value);
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        CodeBuilder cb = mb.getCodeBuilder();
        cb.loadConstant(this.value);
        mb.push(parameter, Types.STRING);
        cb.invokeVirtual(TypeDesc.STRING, "equals", TypeDesc.BOOLEAN, Constants.OBJECTS[1]);
        cb.ifZeroComparisonBranch((Location)failure, "==");
        mb.jump(success);
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return this.value;
    }
}

