/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class SCLConstructor
extends FunctionValue {
    private static int MAX_FIELD_COUNT = 20;
    public static String[][] DEFAULT_FIELD_NAMES = new String[MAX_FIELD_COUNT + 1][];
    String name;
    String className;
    String[] fieldNames;
    boolean onlyConstructor;

    static {
        int i = 0;
        while (i <= MAX_FIELD_COUNT) {
            String[] fieldNames = new String[i];
            int j = 0;
            while (j < i) {
                fieldNames[j] = "c" + j;
                ++j;
            }
            SCLConstructor.DEFAULT_FIELD_NAMES[i] = fieldNames;
            ++i;
        }
    }

    public SCLConstructor(String name, String className, TVar[] typeParameters, Type returnType, String[] fieldNames, Type ... parameterTypes) {
        super(typeParameters, Types.NO_EFFECTS, returnType, parameterTypes);
        this.name = name;
        this.className = className;
        this.fieldNames = fieldNames;
    }

    public SCLConstructor(String name, String className, TVar[] typeParameters, Type returnType, Type ... parameterTypes) {
        this(name, className, typeParameters, returnType, DEFAULT_FIELD_NAMES[parameterTypes.length], parameterTypes);
    }

    public void setOnlyConstructor(boolean onlyConstructor) {
        this.onlyConstructor = onlyConstructor;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        if (this.className == null) {
            mb.push(parameters[0], this.parameterTypes[0]);
            return this.getReturnType();
        }
        TypeDesc typeDesc = TypeDesc.forClass((String)this.className);
        CodeBuilderUtils.constructRecord(typeDesc, mb, this.parameterTypes, parameters);
        return this.getReturnType();
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        CodeBuilder cb = mb.getCodeBuilder();
        JavaTypeTranslator javaTypeTranslator = mb.getJavaTypeTranslator();
        if (this.onlyConstructor) {
            if (this.className == null) {
                Type expectedType;
                TypeDesc expectedDesc;
                TypeDesc parameterDesc = javaTypeTranslator.getTypeDesc(parameter);
                if (parameterDesc.equals((Object)(expectedDesc = javaTypeTranslator.toTypeDesc(expectedType = success.getParameterType(0))))) {
                    mb.jump(success, parameter);
                } else {
                    parameter.push(mb);
                    mb.unbox(expectedType);
                    BoundVar boundVar = new BoundVar(expectedType);
                    mb.store(boundVar);
                    mb.jump(success, boundVar);
                }
                return;
            }
            failure = null;
        }
        Label failureLabel = cb.createLabel();
        TypeDesc constructorType = TypeDesc.forClass((String)this.className);
        mb.push(parameter, this.returnType);
        if (failure != null) {
            cb.dup();
            cb.instanceOf(constructorType);
            cb.ifZeroComparisonBranch((Location)failureLabel, "==");
        }
        if (!this.onlyConstructor) {
            cb.checkCast(constructorType);
        }
        IVal[] parameters = new Val[this.parameterTypes.length];
        int i = 0;
        while (i < this.parameterTypes.length) {
            TypeDesc typeDesc = javaTypeTranslator.toTypeDesc(this.parameterTypes[i]);
            Type contType = success.getParameterType(i);
            if (!typeDesc.equals((Object)TypeDesc.VOID)) {
                cb.dup();
                cb.loadField(this.className, this.fieldNames[i], typeDesc);
                if (typeDesc == TypeDesc.OBJECT) {
                    mb.unbox(contType);
                }
            }
            BoundVar boundVar = new BoundVar(contType);
            mb.store(boundVar);
            parameters[i] = boundVar;
            ++i;
        }
        cb.pop();
        mb.jump(success, parameters);
        if (failure != null) {
            failureLabel.setLocation();
            cb.pop();
            cb.branch((Location)failure);
        }
    }

    public String toString() {
        return this.name;
    }
}

