/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.types.Types;

public class LongConstant
extends Constant {
    long value;

    public LongConstant(long value) {
        super(Types.LONG);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.getCodeBuilder().loadConstant(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongConstant other = (LongConstant)obj;
        return this.value == other.value;
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        CodeBuilder cb = mb.getCodeBuilder();
        mb.push(parameter, Types.LONG);
        cb.loadConstant(this.value);
        cb.ifComparisonBranch((Location)failure, "!=", TypeDesc.LONG);
        mb.jump(success);
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return this.value;
    }
}

