/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class JavaStaticMethod
extends FunctionValue {
    String className;
    String methodName;
    TypeDesc returnTypeDesc;
    TypeDesc[] parameterTypeDescs;

    public JavaStaticMethod(String className, String methodName, Type effect, TVar[] typeParameters, Type returnType, Type ... parameterTypes) {
        super(typeParameters, effect, returnType, parameterTypes);
        this.className = className;
        this.methodName = methodName;
    }

    public JavaStaticMethod(String className, String methodName, Type effect, Type returnType, Type ... parameterTypes) {
        super(Types.freeVarsArray(Types.functionE(parameterTypes, effect, returnType)), effect, returnType, parameterTypes);
        this.className = className;
        this.methodName = methodName;
    }

    public JavaStaticMethod(String className, String methodName, Type effect, TypeDesc returnTypeDesc, TypeDesc[] parameterTypeDescs, Type returnType, Type ... parameterTypes) {
        super(Types.freeVarsArray(Types.functionE(parameterTypes, effect, returnType)), effect, returnType, parameterTypes);
        this.className = className;
        this.methodName = methodName;
        this.returnTypeDesc = returnTypeDesc;
        this.parameterTypeDescs = parameterTypeDescs;
    }

    public JavaStaticMethod(String className, String methodName, TypeDesc returnTypeDesc, TypeDesc[] parameterTypeDescs, Type returnType, Type ... parameterTypes) {
        this(className, methodName, (Type)Types.NO_EFFECTS, returnTypeDesc, parameterTypeDescs, returnType, parameterTypes);
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        if (this.returnTypeDesc == null) {
            JavaTypeTranslator tt = mb.getJavaTypeTranslator();
            this.returnTypeDesc = tt.toTypeDesc(this.returnType);
            this.parameterTypeDescs = JavaTypeTranslator.filterVoid(tt.toTypeDescs(this.parameterTypes));
        }
        CodeBuilder cb = mb.getCodeBuilder();
        mb.push(parameters, this.getParameterTypes());
        cb.invokeStatic(this.className, this.methodName, this.returnTypeDesc, this.parameterTypeDescs);
        return this.getReturnType();
    }

    public String toString() {
        return String.valueOf(this.className) + "#" + this.methodName;
    }
}

