/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import java.lang.reflect.Field;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.top.MapClassLoader;
import org.simantics.scl.types.Type;

public class JavaStaticField
extends Constant {
    String className;
    String fieldName;
    TypeDesc fieldType;
    Type effect;

    public JavaStaticField(String className, String fieldName, Type effect, TypeDesc fieldType, Type type) {
        super(type);
        this.className = className;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.effect = effect;
    }

    public JavaStaticField(String className, String fieldName, Type type) {
        this(className, fieldName, null, null, type);
    }

    @Override
    public void push(MethodBuilder mb) {
        if (this.fieldType == null) {
            JavaTypeTranslator tt = mb.getJavaTypeTranslator();
            this.fieldType = tt.toTypeDesc(this.getType());
        }
        CodeBuilder cb = mb.getCodeBuilder();
        cb.loadStaticField(this.className, this.fieldName, this.fieldType);
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        MapClassLoader classLoader = classBuilder.getClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(this.className);
            Field field = clazz.getField(this.fieldName);
            return field.get(null);
        }
        catch (IllegalArgumentException e) {
            throw new InternalCompilerError(e);
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalCompilerError(e);
        }
        catch (SecurityException e) {
            throw new InternalCompilerError(e);
        }
        catch (NoSuchFieldException e) {
            throw new InternalCompilerError(e);
        }
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        this.push(mb);
        CodeBuilder cb = mb.getCodeBuilder();
        mb.push(parameter, this.getType());
        cb.invokeVirtual(TypeDesc.OBJECT, "equals", TypeDesc.BOOLEAN, Constants.OBJECTS[1]);
        cb.ifZeroComparisonBranch((Location)failure, "==");
        mb.jump(success);
    }

    public String toString() {
        return "JavaStaticField(" + this.className + "." + this.fieldName + ")";
    }
}

