/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class JavaSetField
extends FunctionValue {
    String className;
    String fieldName;
    TypeDesc fieldTypeDesc;

    public JavaSetField(String className, String fieldName, TVar[] typeVariables, TypeDesc fieldTypeDesc, Type fieldType, Type parentType) {
        super(typeVariables, Types.PROC, Types.UNIT, parentType, fieldType);
        this.className = className;
        this.fieldName = fieldName;
        this.fieldTypeDesc = fieldTypeDesc;
    }

    public JavaSetField(String className, String fieldName, TVar[] typeVariables, Type fieldType, Type parentType) {
        this(className, fieldName, typeVariables, null, fieldType, parentType);
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        if (this.fieldTypeDesc == null) {
            JavaTypeTranslator tt = mb.getJavaTypeTranslator();
            this.fieldTypeDesc = tt.toTypeDesc(this.getReturnType());
        }
        CodeBuilder cb = mb.getCodeBuilder();
        mb.push(parameters, this.parameterTypes);
        cb.storeField(this.className, this.fieldName, this.fieldTypeDesc);
        return this.getReturnType();
    }
}

