/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class JavaField
extends FunctionValue {
    String className;
    String fieldName;
    TypeDesc fieldType;

    public JavaField(String className, String fieldName, Type effect, TVar[] typeVariables, TypeDesc fieldType, Type returnType, Type parameterType) {
        super(typeVariables, effect, returnType, parameterType);
        this.className = className;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    public JavaField(String className, String fieldName, TVar[] typeVariables, Type returnType, Type parameterType) {
        this(className, fieldName, (Type)Types.NO_EFFECTS, typeVariables, null, returnType, parameterType);
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        if (this.fieldType == null) {
            JavaTypeTranslator tt = mb.getJavaTypeTranslator();
            this.fieldType = tt.toTypeDesc(this.getReturnType());
        }
        CodeBuilder cb = mb.getCodeBuilder();
        mb.push(parameters, this.parameterTypes);
        cb.loadField(this.className, this.fieldName, this.fieldType);
        return this.getReturnType();
    }
}

