/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class JavaConversionOperation
extends FunctionValue {
    public static final JavaConversionOperation I2L = new JavaConversionOperation("i2l", Types.INTEGER, Types.LONG);
    public static final JavaConversionOperation I2F = new JavaConversionOperation("i2f", Types.INTEGER, Types.FLOAT);
    public static final JavaConversionOperation I2D = new JavaConversionOperation("i2d", Types.INTEGER, Types.DOUBLE);
    public static final JavaConversionOperation L2I = new JavaConversionOperation("l2i", Types.LONG, Types.INTEGER);
    public static final JavaConversionOperation L2F = new JavaConversionOperation("l2f", Types.LONG, Types.FLOAT);
    public static final JavaConversionOperation L2D = new JavaConversionOperation("l2d", Types.LONG, Types.DOUBLE);
    public static final JavaConversionOperation F2I = new JavaConversionOperation("f2i", Types.FLOAT, Types.INTEGER);
    public static final JavaConversionOperation F2L = new JavaConversionOperation("f2l", Types.FLOAT, Types.LONG);
    public static final JavaConversionOperation F2D = new JavaConversionOperation("f2d", Types.FLOAT, Types.DOUBLE);
    public static final JavaConversionOperation D2I = new JavaConversionOperation("d2i", Types.DOUBLE, Types.INTEGER);
    public static final JavaConversionOperation D2L = new JavaConversionOperation("d2l", Types.DOUBLE, Types.LONG);
    public static final JavaConversionOperation D2F = new JavaConversionOperation("d2f", Types.DOUBLE, Types.FLOAT);
    public static final JavaConversionOperation I2B = new JavaConversionOperation("i2b", Types.INTEGER, Types.BYTE);
    public static final JavaConversionOperation I2C = new JavaConversionOperation("i2c", Types.INTEGER, Types.CHARACTER);
    public static final JavaConversionOperation I2S = new JavaConversionOperation("i2s", Types.INTEGER, Types.SHORT);
    public static final JavaConversionOperation B2I = new JavaConversionOperation("b2i", Types.BYTE, Types.INTEGER);
    public static final JavaConversionOperation C2I = new JavaConversionOperation("c2i", Types.CHARACTER, Types.INTEGER);
    public static final JavaConversionOperation S2I = new JavaConversionOperation("s2i", Types.SHORT, Types.INTEGER);
    public final String opcode;
    public static final JavaConversionOperation[] OPCODES = new JavaConversionOperation[]{I2L, I2F, I2D, L2I, L2F, L2D, F2I, F2L, F2D, D2I, D2L, D2F, I2B, I2C, I2S, B2I, C2I, S2I};

    public JavaConversionOperation(String opcode, Type parameterType, Type returnType) {
        super(TVar.EMPTY_ARRAY, Types.NO_EFFECTS, returnType, parameterType);
        this.opcode = opcode;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        CodeBuilder cb = mb.getCodeBuilder();
        JavaTypeTranslator tt = mb.getJavaTypeTranslator();
        mb.push(parameters, this.parameterTypes);
        cb.convert(tt.toTypeDesc(this.parameterTypes[0]), tt.toTypeDesc(this.returnType), 0);
        return this.getReturnType();
    }

    public String getMnemonic() {
        return this.opcode;
    }

    public String toString() {
        return this.opcode;
    }
}

