/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class JavaConstructor
extends FunctionValue {
    String className;
    boolean hasStaticInstance = false;
    TypeDesc[] parameterTypeDescs;

    public JavaConstructor(String className, Type effect, Type returnType, Type ... parameterTypes) {
        super(Types.freeVarsArray(Types.functionE(parameterTypes, effect, returnType)), effect, returnType, parameterTypes);
        this.className = className;
    }

    public JavaConstructor(String className, Type effect, TypeDesc[] parameterTypeDescs, Type returnType, Type ... parameterTypes) {
        super(Types.freeVarsArray(Types.functionE(parameterTypes, effect, returnType)), effect, returnType, parameterTypes);
        this.className = className;
        this.parameterTypeDescs = parameterTypeDescs;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        if (this.parameterTypeDescs == null) {
            JavaTypeTranslator tt = mb.getJavaTypeTranslator();
            this.parameterTypeDescs = tt.toTypeDescs(this.parameterTypes);
        }
        CodeBuilder cb = mb.getCodeBuilder();
        TypeDesc typeDesc = TypeDesc.forClass((String)this.className);
        if (this.hasStaticInstance) {
            cb.loadStaticField(typeDesc, "INSTANCE", typeDesc);
        } else {
            cb.newObject(typeDesc);
            cb.dup();
            mb.push(parameters, this.parameterTypes);
            cb.invokeConstructor(this.className, this.parameterTypeDescs);
        }
        return this.getReturnType();
    }

    public String toString() {
        return String.valueOf(this.className) + ".<init>";
    }

    public void setHasStaticInstance(boolean hasStaticInstance) {
        if (this.parameterTypes.length > 0) {
            throw new InternalCompilerError();
        }
        this.hasStaticInstance = hasStaticInstance;
    }
}

