/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import java.util.Arrays;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.BTypes;
import org.simantics.scl.compiler.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.codegen.values.LocalBoxedArrayElementConstant;
import org.simantics.scl.compiler.codegen.values.LocalVariableConstant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.top.MapClassLoader;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;

public abstract class FunctionValue
extends Constant {
    TVar[] typeParameters;
    Type returnType;
    Type[] parameterTypes;
    Type effect;

    public FunctionValue(TVar[] typeParameters, Type effect, Type returnType, Type ... parameterTypes) {
        super(Types.forAll(typeParameters, Types.functionE(parameterTypes, effect, returnType)));
        this.typeParameters = typeParameters;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.effect = effect;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public TVar[] getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    public void push(MethodBuilder mb) {
        this.apply(mb, Type.EMPTY_ARRAY, new Val[0]);
    }

    @Override
    public Type apply(MethodBuilder mb, Type[] typeParameters, Val ... parameters) {
        int arity = this.getArity();
        if (parameters.length < arity) {
            ModuleBuilder moduleBuilder = mb.getModuleBuilder();
            TypeDesc closureClass = moduleBuilder.getClosure(this, parameters.length);
            CodeBuilderUtils.constructRecord(closureClass, mb, this.parameterTypes, parameters);
            return Types.function(Arrays.copyOfRange(this.parameterTypes, parameters.length, this.parameterTypes.length), this.returnType);
        }
        if (parameters.length > arity) {
            Type returnType = this.applyExact(mb, Arrays.copyOf(parameters, arity));
            mb.pushBoxed(Arrays.copyOfRange(parameters, arity, parameters.length));
            int remainingArity = parameters.length - arity;
            mb.genericApply(remainingArity);
            if (typeParameters.length > 0) {
                returnType = returnType.replace(this.typeParameters, typeParameters);
            }
            try {
                returnType = BTypes.matchFunction(returnType, remainingArity)[remainingArity];
            }
            catch (MatchException e) {
                throw new InternalCompilerError("Tried to apply value of type " + returnType + " with " + remainingArity + " parameters.");
            }
            mb.unbox(returnType);
            return returnType;
        }
        return this.applyExact(mb, parameters);
    }

    public abstract Type applyExact(MethodBuilder var1, Val[] var2);

    @Override
    public int getEffectiveArity() {
        return this.parameterTypes.length;
    }

    @Override
    public Object realizeValue(TransientClassBuilder builder) {
        CodeBuilder cb;
        MethodInfo mi;
        ClassFile classFile;
        int arity = this.getEffectiveArity();
        if (arity == 0) {
            return super.realizeValue(builder);
        }
        String packageName = builder.freshPackageName();
        String moduleName = String.valueOf(packageName) + ".Temp";
        JavaNamingPolicy policy = new JavaNamingPolicy(moduleName);
        ModuleBuilder moduleBuilder = new ModuleBuilder(policy, builder.getJavaTypeTranslator());
        if (arity <= 8) {
            classFile = new ClassFile(policy.getModuleClassName(), Constants.FUNCTION_IMPL[arity].getFullName());
            classFile.setTarget("1.6");
            classFile.setSourceFile("_SCL_FunctionValue");
            classFile.addDefaultConstructor();
            mi = classFile.addMethod(Modifiers.PUBLIC, "apply", TypeDesc.OBJECT, Constants.OBJECTS[arity]);
            cb = new CodeBuilder(mi);
            MethodBuilder mb = new MethodBuilder(moduleBuilder, cb);
            Val[] parameters = new Val[arity];
            int i = 0;
            while (i < arity) {
                parameters[i] = new LocalVariableConstant(this.parameterTypes[i], cb.getParameter(i));
                ++i;
            }
            this.prepare(mb);
            mb.box(this.applyExact(mb, parameters));
            cb.returnValue(TypeDesc.OBJECT);
        } else {
            classFile = new ClassFile(policy.getModuleClassName(), Constants.FUNCTION_N_IMPL.getFullName());
            classFile.setSourceFile("_SCL_FunctionValue");
            mi = classFile.addConstructor(Modifiers.PUBLIC, null);
            cb = new CodeBuilder(mi);
            cb.loadThis();
            cb.loadConstant(arity);
            cb.invokeSuperConstructor(new TypeDesc[]{TypeDesc.INT});
            cb.returnVoid();
            mi = classFile.addMethod(Modifiers.PUBLIC, "doApply", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.forClass(Object[].class)});
            cb = new CodeBuilder(mi);
            MethodBuilder mb = new MethodBuilder(moduleBuilder, cb);
            Val[] parameters = new Val[arity];
            int i = 0;
            while (i < arity) {
                parameters[i] = new LocalBoxedArrayElementConstant(this.parameterTypes[i], cb.getParameter(0), i);
                ++i;
            }
            this.applyExact(mb, parameters);
            mb.box(this.returnType);
            cb.returnValue(TypeDesc.OBJECT);
        }
        moduleBuilder.addClass(classFile);
        MapClassLoader classLoader = builder.getClassLoader();
        classLoader.addClasses(moduleBuilder.getClasses());
        try {
            return classLoader.loadClass(policy.getModuleClassName()).newInstance();
        }
        catch (InstantiationException e) {
            throw new InternalCompilerError(e);
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalCompilerError(e);
        }
    }
}

