/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.types.Types;

public class FloatConstant
extends Constant {
    float value;

    public FloatConstant(float value) {
        super(Types.FLOAT);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.getCodeBuilder().loadConstant(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatConstant other = (FloatConstant)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        CodeBuilder cb = mb.getCodeBuilder();
        mb.push(parameter, Types.FLOAT);
        cb.loadConstant(this.value);
        cb.ifComparisonBranch((Location)failure, "!=", TypeDesc.FLOAT);
        mb.jump(success);
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return Float.valueOf(this.value);
    }
}

