/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.types.Types;

public class DoubleConstant
extends Constant {
    double value;

    public DoubleConstant(double value) {
        super(Types.DOUBLE);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.getCodeBuilder().loadConstant(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleConstant other = (DoubleConstant)obj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        CodeBuilder cb = mb.getCodeBuilder();
        mb.push(parameter, Types.DOUBLE);
        cb.loadConstant(this.value);
        cb.ifComparisonBranch((Location)failure, "!=", TypeDesc.DOUBLE);
        mb.jump(success);
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return this.value;
    }
}

