/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.top.MapClassLoader;
import org.simantics.scl.types.Type;

public abstract class Constant
extends Val {
    protected Type type;

    public Constant(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public int getArity() {
        return 0;
    }

    @Override
    public void push(MethodBuilder mb) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support push.");
    }

    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support deconstruct.");
    }

    public void inline(SSASimplificationContext context, LetApply apply) {
    }

    @Override
    public Val copy() {
        return this;
    }

    @Override
    public int getEffectiveArity() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder builder) {
        String packageName = builder.freshPackageName();
        String moduleName = String.valueOf(packageName) + "/Temp";
        JavaNamingPolicy policy = new JavaNamingPolicy(moduleName);
        ModuleBuilder moduleBuilder = new ModuleBuilder(policy, builder.getJavaTypeTranslator());
        ClassFile classFile = new ClassFile(policy.getModuleClassName());
        classFile.setSourceFile("_SCL_RealizedValue");
        classFile.addField(Modifiers.PUBLIC_STATIC, "VALUE", TypeDesc.OBJECT);
        MethodInfo mi = classFile.addInitializer();
        CodeBuilder cb = new CodeBuilder(mi);
        MethodBuilder mb = new MethodBuilder(moduleBuilder, cb);
        mb.pushBoxed(this);
        cb.storeStaticField("VALUE", TypeDesc.OBJECT);
        cb.returnVoid();
        moduleBuilder.addClass(classFile);
        MapClassLoader classLoader = builder.getClassLoader();
        classLoader.addClasses(moduleBuilder.getClasses());
        try {
            return classLoader.loadClass(policy.getModuleClassName()).getField("VALUE").get(null);
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalCompilerError(e);
        }
        catch (IllegalArgumentException e) {
            throw new InternalCompilerError(e);
        }
        catch (SecurityException e) {
            throw new InternalCompilerError(e);
        }
        catch (NoSuchFieldException e) {
            throw new InternalCompilerError(e);
        }
    }
}

