/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.values;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.types.Types;

public class CharacterConstant
extends Constant {
    char value;

    public CharacterConstant(char value) {
        super(Types.CHARACTER);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.getCodeBuilder().loadConstant((int)this.value);
    }

    public String toString() {
        return "'" + Character.toString(this.value) + "'";
    }

    public char getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CharacterConstant other = (CharacterConstant)obj;
        return this.value == other.value;
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        CodeBuilder cb = mb.getCodeBuilder();
        mb.push(parameter, Types.CHARACTER);
        cb.loadConstant((int)this.value);
        cb.ifComparisonBranch((Location)failure, "!=", TypeDesc.CHAR);
        mb.jump(success);
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return Character.valueOf(this.value);
    }
}

