/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.utils;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.continuations.ContRef;
import org.simantics.scl.compiler.codegen.continuations.ReturnCont;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class PrintingContext {
    THashMap<Object, String> names = new THashMap();
    int nameId = 0;
    int indentation = 0;
    StringBuilder stringBuilder = new StringBuilder();
    TypeUnparsingContext typeUnparsingContext = new TypeUnparsingContext();
    Object errorMarker;
    THashMap<BoundVar, LetApply> inlineExpressions = new THashMap();
    private ArrayList<BlockEntry> blockQueueStack = new ArrayList(2);
    private static final int alphabetCount = 26;

    public void pushBlockQueue() {
        this.blockQueueStack.add(new BlockEntry());
    }

    public void popBlockQueue() {
        this.blockQueueStack.remove(this.blockQueueStack.size() - 1);
    }

    public SSABlock pollBlock() {
        BlockEntry entry = this.blockQueueStack.get(this.blockQueueStack.size() - 1);
        return entry.blockQueue.poll();
    }

    public void addBlock(SSABlock block) {
        BlockEntry entry = this.blockQueueStack.get(this.blockQueueStack.size() - 1);
        if (entry.blockSet.add((Object)block)) {
            entry.blockQueue.add(block);
        }
    }

    public void append(Constant val) {
        this.append(val.toString());
    }

    public void append(ReturnCont val) {
        this.append("return");
    }

    public void append(Type type) {
        this.append(type.toString(this.typeUnparsingContext));
    }

    public void append(Type[] types) {
        this.append('[');
        boolean first = true;
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (first) {
                first = false;
            } else {
                this.append(", ");
            }
            this.append(type);
            ++n2;
        }
        this.append(']');
    }

    public void append(ValRef ref) {
        this.append(ref.getBinding());
        if (ref.getTypeParameters().length > 0) {
            this.append("<");
            int i = 0;
            while (i < ref.getTypeParameters().length) {
                if (i > 0) {
                    this.append(",");
                }
                this.append(ref.getTypeParameters()[i].toString(this.typeUnparsingContext));
                ++i;
            }
            this.append(">");
        }
    }

    public void append(Val val) {
        if (val instanceof Constant) {
            this.append((Constant)val);
        } else if (val instanceof BoundVar) {
            BoundVar var = (BoundVar)val;
            LetApply inlineExpression = (LetApply)this.inlineExpressions.remove((Object)var);
            if (inlineExpression != null) {
                this.append('(');
                inlineExpression.bodyToString(this);
                this.append(')');
            } else {
                String label = var.getLabel();
                if (label == null) {
                    label = this.getName(val);
                }
                this.append(label);
            }
        } else {
            this.append(this.getName(val));
        }
    }

    public void append(ContRef ref) {
        this.append(ref.getBinding());
    }

    public void append(Cont cont) {
        if (cont instanceof ReturnCont) {
            this.append((ReturnCont)cont);
        } else {
            this.append("[" + this.getName(cont) + "]");
        }
    }

    private String getName(Object var) {
        if (var == null) {
            return "NULL";
        }
        String name = (String)this.names.get(var);
        if (name == null) {
            name = PrintingContext.idToName(this.nameId++);
            this.names.put(var, (Object)name);
        }
        return name;
    }

    private static String idToName(int id) {
        String name = Character.toString((char)(97 + id % 26));
        if ((id /= 26) > 0) {
            name = String.valueOf(PrintingContext.idToName(id - 1)) + name;
        }
        return name;
    }

    public PrintingContext append(String str) {
        this.stringBuilder.append(str);
        return this;
    }

    public PrintingContext append(char c) {
        this.stringBuilder.append(c);
        return this;
    }

    public void indentation() {
        int i = 0;
        while (i < this.indentation) {
            this.stringBuilder.append("    ");
            ++i;
        }
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    public void indent() {
        ++this.indentation;
    }

    public void dedent() {
        --this.indentation;
    }

    public void setErrorMarker(Object errorMarker) {
        this.errorMarker = errorMarker;
    }

    public Object getErrorMarker() {
        return this.errorMarker;
    }

    public void addInlineExpression(BoundVar target, LetApply letApply) {
        this.inlineExpressions.put((Object)target, (Object)letApply);
    }

    private static class BlockEntry {
        ArrayDeque<SSABlock> blockQueue = new ArrayDeque();
        THashSet<SSABlock> blockSet = new THashSet();

        private BlockEntry() {
        }
    }
}

