/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.utils;

public class NameMangling {
    private static final boolean[] NORMAL_CHAR = new boolean[128];
    private static final char[] REWRITE_CHAR = new char[128];
    private static final char[] INVERSE_REWRITE_CHAR = new char[128];

    static {
        int c = 97;
        while (c <= 122) {
            NameMangling.NORMAL_CHAR[c] = true;
            c = (char)(c + 1);
        }
        c = 65;
        while (c <= 90) {
            NameMangling.NORMAL_CHAR[c] = true;
            c = (char)(c + 1);
        }
        c = 48;
        while (c <= 57) {
            NameMangling.NORMAL_CHAR[c] = true;
            c = (char)(c + 1);
        }
        NameMangling.REWRITE_CHAR[38] = 97;
        NameMangling.REWRITE_CHAR[37] = 99;
        NameMangling.REWRITE_CHAR[47] = 100;
        NameMangling.REWRITE_CHAR[61] = 101;
        NameMangling.REWRITE_CHAR[62] = 103;
        NameMangling.REWRITE_CHAR[35] = 104;
        NameMangling.REWRITE_CHAR[60] = 108;
        NameMangling.REWRITE_CHAR[45] = 109;
        NameMangling.REWRITE_CHAR[124] = 111;
        NameMangling.REWRITE_CHAR[43] = 112;
        NameMangling.REWRITE_CHAR[63] = 113;
        NameMangling.REWRITE_CHAR[42] = 116;
        NameMangling.REWRITE_CHAR[95] = 117;
        NameMangling.REWRITE_CHAR[33] = 120;
        NameMangling.REWRITE_CHAR[64] = 65;
        NameMangling.REWRITE_CHAR[58] = 67;
        NameMangling.REWRITE_CHAR[36] = 68;
        NameMangling.REWRITE_CHAR[46] = 80;
        c = 0;
        while (c < 128) {
            char r = REWRITE_CHAR[c];
            if (r != '\u0000') {
                NameMangling.INVERSE_REWRITE_CHAR[r] = c;
            }
            c = (char)(c + 1);
        }
    }

    public static String mangle(String name) {
        int length = name.length();
        int i = 0;
        while (i < length) {
            char c = name.charAt(i);
            if (c >= '\u0080' || !NORMAL_CHAR[c]) {
                StringBuilder b = new StringBuilder(name.substring(0, i));
                boolean normalMode = true;
                while (i < length) {
                    c = name.charAt(i);
                    if (c < '\u0080' && NORMAL_CHAR[c]) {
                        if (!normalMode) {
                            b.append('_');
                            normalMode = true;
                        }
                        b.append(c);
                    } else {
                        char r;
                        if (normalMode) {
                            b.append('_');
                            normalMode = false;
                        }
                        char c2 = r = c < '\u0080' ? REWRITE_CHAR[c] : (char)'\u0000';
                        if (r == '\u0000') {
                            b.append((int)c);
                            b.append('_');
                        } else {
                            b.append(r);
                        }
                    }
                    ++i;
                }
                return b.toString();
            }
            ++i;
        }
        return name;
    }

    public static String demangle(String name) {
        int length = name.length();
        int i = 0;
        while (i < length) {
            char c = name.charAt(i);
            if (c == '_') {
                StringBuilder b = new StringBuilder(name.substring(0, i));
                boolean normalMode = false;
                ++i;
                while (i < length) {
                    c = name.charAt(i);
                    if (c == '_') {
                        normalMode = !normalMode;
                    } else if (normalMode) {
                        b.append(c);
                    } else if (c >= '0' && c <= '9') {
                        int l = name.substring(i).indexOf(95);
                        char r = (char)Integer.parseInt(name.substring(i, i + l));
                        i += l;
                        b.append(r);
                    } else {
                        b.append(INVERSE_REWRITE_CHAR[c]);
                    }
                    ++i;
                }
                return b.toString();
            }
            ++i;
        }
        return name;
    }

    public static void test(String name) {
        String name2 = NameMangling.mangle(name);
        String name3 = NameMangling.demangle(name2);
        System.out.println(String.valueOf(name) + " -> " + name2 + " -> " + name3);
    }

    public static void main(String[] args) {
        NameMangling.test("hello");
        NameMangling.test("hello_world");
        NameMangling.test("++");
        NameMangling.test("$");
        NameMangling.test("{}");
        NameMangling.test("<");
        NameMangling.test("<=");
        NameMangling.test(">");
        NameMangling.test(">=");
    }
}

