/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.utils;

import gnu.trove.map.hash.THashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.compiler.codegen.values.LocalFieldConstant;
import org.simantics.scl.compiler.codegen.values.LocalVariableConstant;
import org.simantics.scl.types.Type;

public class ModuleBuilder {
    JavaNamingPolicy namingPolicy;
    JavaTypeTranslator javaTypeTranslator;
    THashMap<String, byte[]> classes = new THashMap();
    THashMap<ClosureDesc, TypeDesc> cache = new THashMap();

    public void addClass(ClassFile cf) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            cf.writeTo((OutputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.classes.put((Object)cf.getClassName(), (Object)stream.toByteArray());
    }

    public JavaTypeTranslator getJavaTypeTranslator() {
        return this.javaTypeTranslator;
    }

    public ModuleBuilder(JavaNamingPolicy namingPolicy, JavaTypeTranslator javaTypeTranslator) {
        this.namingPolicy = namingPolicy;
        this.javaTypeTranslator = javaTypeTranslator;
    }

    public TypeDesc getClosure(FunctionValue functionValue, int knownParametersCount) {
        ClosureDesc desc = new ClosureDesc(functionValue, knownParametersCount);
        TypeDesc result = (TypeDesc)this.cache.get((Object)desc);
        if (result == null) {
            result = this.createClosure(functionValue, knownParametersCount);
            this.cache.put((Object)desc, (Object)result);
        }
        return result;
    }

    private TypeDesc createClosure(FunctionValue functionValue, int knownParametersCount) {
        ClassFile classFile;
        String className = this.namingPolicy.getFreshClosureClassName();
        int remainingArity = functionValue.getArity() - knownParametersCount;
        TypeDesc[] parameterTypes = this.javaTypeTranslator.toTypeDescs(functionValue.getParameterTypes());
        if (remainingArity <= 8) {
            classFile = new ClassFile(className, Constants.FUNCTION_IMPL[remainingArity].getFullName());
            classFile.setTarget("1.6");
            classFile.setSourceFile("_SCL_Closure");
            CodeBuilderUtils.makeRecord(classFile, functionValue.toString(), Constants.PRIVATE_FINAL, "p", Arrays.copyOf(parameterTypes, knownParametersCount));
            MethodInfo mi = classFile.addMethod(Modifiers.PUBLIC, "apply", TypeDesc.OBJECT, Constants.OBJECTS[remainingArity]);
            CodeBuilder cb = new CodeBuilder(mi);
            MethodBuilder mb = new MethodBuilder(this, cb);
            Val[] parameters = new Val[functionValue.getArity()];
            int i = 0;
            while (i < knownParametersCount) {
                parameters[i] = new LocalFieldConstant(functionValue.getParameterTypes()[i], "p" + i);
                ++i;
            }
            i = 0;
            while (i < remainingArity) {
                Type type = functionValue.getParameterTypes()[knownParametersCount + i];
                parameters[knownParametersCount + i] = new LocalVariableConstant(type, cb.getParameter(i));
                ++i;
            }
            functionValue.prepare(mb);
            Type returnType = functionValue.applyExact(mb, parameters);
            mb.box(returnType);
            cb.returnValue(TypeDesc.OBJECT);
        } else {
            classFile = new ClassFile(className, Constants.FUNCTION_N_IMPL.getFullName());
            classFile.setTarget("1.6");
            classFile.setSourceFile("_SCL_Closure");
            int i = 0;
            while (i < knownParametersCount) {
                classFile.addField(Constants.PRIVATE_FINAL, "p" + i, parameterTypes[i]);
                ++i;
            }
            MethodInfo mi = classFile.addConstructor(Modifiers.PUBLIC, Arrays.copyOf(parameterTypes, knownParametersCount));
            CodeBuilder cb = new CodeBuilder(mi);
            cb.loadThis();
            cb.loadConstant(remainingArity);
            cb.invokeSuperConstructor(new TypeDesc[]{TypeDesc.INT});
            int i2 = 0;
            while (i2 < knownParametersCount) {
                cb.loadThis();
                cb.loadLocal(cb.getParameter(i2));
                cb.storeField("p" + i2, parameterTypes[i2]);
                ++i2;
            }
            cb.returnVoid();
            mi = classFile.addMethod(Modifiers.PUBLIC, "doApply", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.forClass(Object[].class)});
            cb = new CodeBuilder(mi);
            MethodBuilder mb = new MethodBuilder(this, cb);
            Val[] parameters = new Val[functionValue.getArity()];
            int i3 = 0;
            while (i3 < knownParametersCount) {
                parameters[i3] = new LocalFieldConstant(functionValue.getParameterTypes()[i3], "p" + i3);
                ++i3;
            }
            LocalVariable parameter = cb.getParameter(0);
            int i4 = 0;
            while (i4 < remainingArity) {
                cb.loadLocal(parameter);
                cb.loadConstant(i4);
                cb.loadFromArray(TypeDesc.OBJECT);
                Type type = functionValue.getParameterTypes()[knownParametersCount + i4];
                TypeDesc typeDesc = this.javaTypeTranslator.toTypeDesc(type);
                mb.unbox(type);
                LocalVariable lv = cb.createLocalVariable("p" + (i4 + knownParametersCount), typeDesc);
                cb.storeLocal(lv);
                BoundVar var = new BoundVar(type);
                parameters[knownParametersCount + i4] = var;
                mb.setLocalVariable(var, lv);
                ++i4;
            }
            functionValue.applyExact(mb, parameters);
            mb.box(functionValue.getReturnType());
            cb.returnValue(TypeDesc.OBJECT);
        }
        this.addClass(classFile);
        return TypeDesc.forClass((String)className);
    }

    public Map<String, byte[]> getClasses() {
        return this.classes;
    }

    public JavaNamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    static class ClosureDesc {
        FunctionValue functionValue;
        int knownParametersCount;

        public ClosureDesc(FunctionValue functionValue, int knownParametersCount) {
            this.functionValue = functionValue;
            this.knownParametersCount = knownParametersCount;
        }

        public int hashCode() {
            return this.functionValue.hashCode() + 31 * this.knownParametersCount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ClosureDesc other = (ClosureDesc)obj;
            return this.functionValue == other.functionValue && this.knownParametersCount == other.knownParametersCount;
        }
    }
}

