/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.utils;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.continuations.ContRef;
import org.simantics.scl.compiler.codegen.continuations.ReturnCont;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.codegen.utils.PreparationStep;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class MethodBuilder {
    ModuleBuilder moduleBuilder;
    CodeBuilder codeBuilder;
    THashMap<Cont, Label> labels = new THashMap();
    THashMap<BoundVar, LocalVariable> localVariables = new THashMap();
    THashSet<Cont> generatedConts = new THashSet();
    THashMap<Object, Object> preparationSteps = new THashMap(4);

    public MethodBuilder(ModuleBuilder moduleBuilder, CodeBuilder codeBuilder) {
        this.moduleBuilder = moduleBuilder;
        this.codeBuilder = codeBuilder;
    }

    public CodeBuilder getCodeBuilder() {
        return this.codeBuilder;
    }

    public JavaTypeTranslator getJavaTypeTranslator() {
        return this.getModuleBuilder().getJavaTypeTranslator();
    }

    public ModuleBuilder getModuleBuilder() {
        return this.moduleBuilder;
    }

    public void push(IVal val, Type type) {
        val.push(this);
        if (Types.canonical(type) instanceof TVar) {
            this.box(val.getType());
        }
    }

    public void push(Val[] vals, Type[] types) {
        assert (vals.length == types.length);
        int i = 0;
        while (i < vals.length) {
            this.push(vals[i], types[i]);
            ++i;
        }
    }

    public void pushBoxed(Val val) {
        val.push(this);
        this.box(val.getType());
    }

    public void pushBoxed(Val[] vals) {
        Val[] valArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Val val = valArray[n2];
            this.pushBoxed(val);
            ++n2;
        }
    }

    public void genericApply(int arity) {
        this.codeBuilder.invokeInterface(Constants.FUNCTION, "apply", TypeDesc.OBJECT, Constants.OBJECTS[arity]);
    }

    private void boxPrimitiveType(TypeDesc primitiveType) {
        if (primitiveType.equals((Object)TypeDesc.VOID)) {
            this.codeBuilder.loadStaticField(Constants.TUPLE0, "INSTANCE", Constants.TUPLE0);
        } else {
            TypeDesc objectType = primitiveType.toObjectType();
            this.codeBuilder.invokeStatic(objectType.getFullName(), "valueOf", objectType, new TypeDesc[]{primitiveType});
        }
    }

    public void box(Type type) {
        TypeDesc typeDesc = this.getJavaTypeTranslator().toTypeDesc(type);
        if (typeDesc.isPrimitive()) {
            this.boxPrimitiveType(typeDesc);
        }
    }

    public void unbox(Type type) {
        TypeDesc td = this.getJavaTypeTranslator().toTypeDesc(type);
        if (td.equals((Object)TypeDesc.VOID)) {
            this.codeBuilder.pop();
            return;
        }
        if (td.isPrimitive()) {
            TypeDesc objectType = td.toObjectType();
            this.codeBuilder.checkCast(objectType);
            this.codeBuilder.convert(objectType, td);
        } else if (td != TypeDesc.OBJECT) {
            this.codeBuilder.checkCast(td);
        }
    }

    public void setLocation(Cont continuation) {
        this.getLabel(continuation).setLocation();
        if (!this.generatedConts.add((Object)continuation)) {
            throw new InternalCompilerError("Label location is set multiple times");
        }
    }

    public Label getLabel(Cont continuation) {
        Label label = (Label)this.labels.get((Object)continuation);
        if (label == null) {
            label = this.codeBuilder.createLabel();
            this.labels.put((Object)continuation, (Object)label);
        }
        return label;
    }

    public void setLocalVariable(BoundVar var, LocalVariable localVariable) {
        this.localVariables.put((Object)var, (Object)localVariable);
    }

    public LocalVariable getLocalVariable(BoundVar var) {
        LocalVariable localVariable = (LocalVariable)this.localVariables.get((Object)var);
        if (localVariable == null) {
            TypeDesc typeDesc = this.getJavaTypeTranslator().getTypeDesc(var);
            localVariable = this.codeBuilder.createLocalVariable(null, typeDesc);
            this.localVariables.put((Object)var, (Object)localVariable);
        }
        return localVariable;
    }

    public void jump(ContRef target) {
        this.jump(target.getBinding());
    }

    public void jump(ContRef target, Val ... parameters) {
        this.jump(target.getBinding(), (IVal[])parameters);
    }

    public void jump(Cont cont) {
        if (cont instanceof SSABlock) {
            SSABlock block = (SSABlock)cont;
            if (this.generatedConts.contains((Object)block)) {
                this.codeBuilder.branch((Location)this.getLabel(block));
            } else {
                block.generateCode(this);
            }
        } else {
            throw new InternalCompilerError();
        }
    }

    public void jump(Cont cont, IVal ... parameters) {
        if (cont instanceof ReturnCont) {
            ReturnCont returnCont = (ReturnCont)cont;
            if (parameters.length != 1) {
                throw new InternalCompilerError();
            }
            parameters[0].push(this);
            this.codeBuilder.returnValue(this.getJavaTypeTranslator().toTypeDesc(returnCont.getType()));
        } else if (cont instanceof SSABlock) {
            SSABlock block = (SSABlock)cont;
            BoundVar[] parameterVars = block.getParameters();
            if (parameters.length != parameterVars.length) {
                throw new InternalCompilerError();
            }
            int i = 0;
            while (i < parameters.length) {
                if (parameters[i] != parameterVars[i]) {
                    parameters[i].push(this);
                }
                ++i;
            }
            i = parameters.length - 1;
            while (i >= 0) {
                if (parameters[i] != parameterVars[i]) {
                    this.store(parameterVars[i]);
                }
                --i;
            }
            if (this.generatedConts.contains((Object)block)) {
                this.codeBuilder.branch((Location)this.getLabel(block));
            } else {
                block.generateCode(this);
            }
        } else {
            throw new InternalCompilerError();
        }
    }

    public void store(BoundVar var) {
        Type type = var.getType();
        TypeDesc typeDesc = this.getJavaTypeTranslator().toTypeDesc(type);
        if (typeDesc.equals((Object)TypeDesc.VOID)) {
            return;
        }
        LocalVariable lv = this.getLocalVariable(var);
        this.codeBuilder.storeLocal(lv);
    }

    public void ensureExists(Cont continuation) {
        if (!this.generatedConts.contains((Object)continuation)) {
            ((SSABlock)continuation).generateCode(this);
        }
    }

    public <T> T getPreparation(PreparationStep<T> step) {
        return (T)this.preparationSteps.get(step);
    }

    public <T> void addPreparation(PreparationStep<T> step, T result) {
        this.preparationSteps.put(step, result);
    }
}

