/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.utils;

import org.simantics.scl.compiler.codegen.utils.NameMangling;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TPred;

public class JavaNamingPolicy {
    String moduleName;
    String moduleClassName;
    int closureCount = 0;

    public JavaNamingPolicy(String moduleName) {
        this.moduleName = moduleName;
        if (moduleName.startsWith("http://")) {
            moduleName = moduleName.substring(7);
        }
        moduleName = moduleName.replace('/', '.');
        moduleName = moduleName.replace(':', '_');
        this.moduleClassName = moduleName = moduleName.replace(' ', '_');
    }

    public String getModuleClassName() {
        return this.moduleClassName;
    }

    public String getMethodName(String name) {
        return NameMangling.mangle(name);
    }

    public String getFreshClosureClassName() {
        return String.valueOf(this.moduleClassName) + "$" + ++this.closureCount;
    }

    public String getDataTypeClassName(String name) {
        return String.valueOf(this.moduleClassName) + "$" + name;
    }

    public String getConstructorClassName(String name) {
        return String.valueOf(this.moduleClassName) + "$" + name + "Constructor";
    }

    public String getTypeClassInterfaceName(TCon name) {
        return String.valueOf(this.moduleClassName) + "$" + name.name + "Class";
    }

    public String getTypeClassInstanceClassName(String name) {
        return String.valueOf(this.moduleClassName) + "$" + name + "Instance";
    }

    public String getInstanceClassName(TPred instance) {
        return String.valueOf(this.moduleClassName) + "$" + NameMangling.mangle(instance.toName());
    }

    public String getModuleName() {
        return this.moduleName;
    }
}

