/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.utils;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.continuations.ContRef;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;

public class CopyContext {
    THashMap<Val, Val> valMap = new THashMap();
    THashMap<Cont, Cont> contMap = new THashMap();

    public void put(Val src, Val tgt) {
        Val ret = (Val)this.valMap.put((Object)src, (Object)tgt);
    }

    public void put(Cont src, Cont tgt) {
        Cont ret = (Cont)this.contMap.put((Object)src, (Object)tgt);
    }

    public BoundVar[] copy(BoundVar[] src) {
        BoundVar[] tgt = new BoundVar[src.length];
        int i = 0;
        while (i < src.length) {
            tgt[i] = this.copy(src[i]);
            ++i;
        }
        return tgt;
    }

    public ValRef[] copy(ValRef[] src) {
        ValRef[] tgt = new ValRef[src.length];
        int i = 0;
        while (i < src.length) {
            tgt[i] = this.copy(src[i]);
            ++i;
        }
        return tgt;
    }

    public ValRef copy(ValRef src) {
        return this.copy(src.getBinding()).createOccurrence(src.getTypeParameters());
    }

    public <T extends Val> T copy(T src) {
        Val tgt = (Val)this.valMap.get(src);
        if (tgt != null) {
            return (T)tgt;
        }
        tgt = src.copy();
        this.valMap.put(src, (Object)tgt);
        return (T)tgt;
    }

    public ContRef[] copy(ContRef[] src) {
        ContRef[] tgt = new ContRef[src.length];
        int i = 0;
        while (i < src.length) {
            tgt[i] = this.copy(src[i]);
            ++i;
        }
        return tgt;
    }

    public ContRef copy(ContRef src) {
        return this.copy(src.getBinding()).createOccurrence();
    }

    public <T extends Cont> T copy(T src) {
        Cont tgt = (Cont)this.contMap.get(src);
        if (tgt != null) {
            return (T)tgt;
        }
        tgt = src.copy(this);
        this.contMap.put(src, (Object)tgt);
        return (T)tgt;
    }
}

