/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.utils;

import java.util.Arrays;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.types.Type;

public class CodeBuilderUtils {
    public static void makeRecord(ClassFile classFile, String recordName, Modifiers fieldModifiers, String fieldNamePrefix, TypeDesc[] types) {
        int i = 0;
        while (i < types.length) {
            if (!types[i].equals((Object)TypeDesc.VOID)) {
                classFile.addField(fieldModifiers, String.valueOf(fieldNamePrefix) + i, types[i]);
            }
            ++i;
        }
        MethodInfo mi = classFile.addConstructor(types.length == 0 ? Modifiers.PRIVATE : Modifiers.PUBLIC, JavaTypeTranslator.filterVoid(types));
        CodeBuilder cb = new CodeBuilder(mi);
        cb.loadThis();
        cb.invokeSuperConstructor(Constants.EMPTY_TYPEDESC_ARRAY);
        if (types.length == 0) {
            TypeDesc thisClass = classFile.getType();
            classFile.addField(Constants.PUBLIC_STATIC_FINAL, "INSTANCE", thisClass);
            MethodInfo inimi = classFile.addInitializer();
            CodeBuilder inicb = new CodeBuilder(inimi);
            inicb.newObject(thisClass);
            inicb.dup();
            inicb.invokeConstructor(Constants.EMPTY_TYPEDESC_ARRAY);
            inicb.storeStaticField("INSTANCE", thisClass);
            inicb.returnVoid();
        } else {
            int i2 = 0;
            int j = 0;
            while (i2 < types.length) {
                if (!types[i2].equals((Object)TypeDesc.VOID)) {
                    cb.loadThis();
                    cb.loadLocal(cb.getParameter(j++));
                    cb.storeField(String.valueOf(fieldNamePrefix) + i2, types[i2]);
                }
                ++i2;
            }
        }
        cb.returnVoid();
        MethodInfo tsmi = classFile.addMethod(Modifiers.PUBLIC, "toString", TypeDesc.STRING, Constants.EMPTY_TYPEDESC_ARRAY);
        CodeBuilder tscb = new CodeBuilder(tsmi);
        if (types.length > 0) {
            tscb.newObject(TypeDesc.forClass(StringBuilder.class));
            tscb.dup();
            tscb.invokeConstructor("java.lang.StringBuilder", Constants.EMPTY_TYPEDESC_ARRAY);
            tscb.loadConstant("(" + recordName);
            CodeBuilderUtils.StringBuilder_appendString(tscb);
            int i3 = 0;
            while (i3 < types.length) {
                if (types[i3].equals((Object)TypeDesc.VOID)) {
                    tscb.loadConstant(" ()");
                    CodeBuilderUtils.StringBuilder_appendString(tscb);
                } else {
                    tscb.loadConstant(" ");
                    CodeBuilderUtils.StringBuilder_appendString(tscb);
                    tscb.loadThis();
                    tscb.loadField(String.valueOf(fieldNamePrefix) + i3, types[i3]);
                    CodeBuilderUtils.StringBuilder_appendObject(tscb, types[i3]);
                }
                ++i3;
            }
            tscb.loadConstant(")");
            CodeBuilderUtils.StringBuilder_appendString(tscb);
            tscb.invokeVirtual("java.lang.StringBuilder", "toString", TypeDesc.STRING, Constants.EMPTY_TYPEDESC_ARRAY);
        } else {
            tscb.loadConstant(recordName);
        }
        tscb.returnValue(TypeDesc.STRING);
    }

    public static void constructRecord(TypeDesc clazz, MethodBuilder mb, Type[] parameterTypes, Val ... parameters) {
        CodeBuilder cb = mb.getCodeBuilder();
        if (parameters.length == 0) {
            cb.loadStaticField(clazz, "INSTANCE", clazz);
        } else {
            cb.newObject(clazz);
            cb.dup();
            int i = 0;
            while (i < parameters.length) {
                mb.push(parameters[i], parameterTypes[i]);
                ++i;
            }
            JavaTypeTranslator tt = mb.moduleBuilder.getJavaTypeTranslator();
            cb.invokeConstructor(clazz, JavaTypeTranslator.filterVoid(tt.toTypeDescs(Arrays.copyOf(parameterTypes, parameters.length))));
        }
    }

    public static void StringBuilder_appendString(CodeBuilder cb) {
        cb.invokeVirtual("java.lang.StringBuilder", "append", TypeDesc.forClass((String)"java.lang.StringBuilder"), new TypeDesc[]{TypeDesc.STRING});
    }

    public static void StringBuilder_appendObject(CodeBuilder cb, TypeDesc type) {
        if (!type.isPrimitive() && type != TypeDesc.STRING) {
            type = TypeDesc.OBJECT;
        }
        cb.invokeVirtual("java.lang.StringBuilder", "append", TypeDesc.forClass((String)"java.lang.StringBuilder"), new TypeDesc[]{type});
    }
}

