/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.types;

import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.KArrow;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.Kinds;

public abstract class TypeConstructor {
    public Kind kind;
    public TCon name;
    public TVar[] parameters;
    public Type type;
    public Constructor[] constructors = Constructor.EMPTY_ARRAY;
    public boolean isOpen = true;

    public TypeConstructor(Kind kind) {
        this.kind = kind;
    }

    public TypeConstructor(TCon name, Kind kind) {
        this.name = name;
        this.kind = kind;
        ArrayList<TVar> vars = new ArrayList<TVar>(2);
        Kind cur = kind;
        while (cur instanceof KArrow) {
            KArrow arrow = (KArrow)cur;
            vars.add(Types.var(arrow.domain));
            cur = arrow.range;
        }
        this.parameters = vars.toArray(new TVar[vars.size()]);
        this.type = Types.apply((Type)name, this.parameters);
    }

    public TypeConstructor(TCon name, TVar ... parameters) {
        this.setType(name, parameters);
        Kind kind = Kinds.STAR;
        int i = parameters.length - 1;
        while (i >= 0) {
            kind = Kinds.arrow(parameters[i].getKind(), kind);
            --i;
        }
        this.kind = kind;
    }

    public void setType(TCon name, TVar ... parameters) {
        this.name = name;
        this.parameters = parameters;
        this.type = Types.apply((Type)name, parameters);
    }

    public void setConstructors(Constructor ... constructors) {
        this.constructors = constructors;
    }

    public abstract TypeDesc construct(JavaTypeTranslator var1, Type[] var2);
}

