/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.ssa.statements;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.SSAStatement;
import org.simantics.scl.compiler.codegen.ssa.binders.FunctionBinder;
import org.simantics.scl.compiler.codegen.utils.CopyContext;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.codegen.utils.SSALambdaLiftingContext;
import org.simantics.scl.compiler.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.codegen.values.SCLConstant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;

public class LetFunctions
extends SSAStatement
implements FunctionBinder {
    long recursiveGroupLocation;
    SSAFunction firstFunction;

    public LetFunctions() {
    }

    public LetFunctions(SSAFunction function) {
        this.firstFunction = function;
        function.setParent(this);
    }

    @Override
    public void toString(PrintingContext context) {
        SSAFunction function = this.firstFunction;
        while (function != null) {
            context.indentation();
            context.append(function.getTarget());
            context.append("(" + function.getTarget().occurrenceCount() + ")");
            context.append(" = \n");
            context.indent();
            function.toString(context);
            context.dedent();
            function = function.getNext();
        }
    }

    public void addFunction(SSAFunction function) {
        function.setParent(this);
        function.setNext(this.firstFunction);
        if (this.firstFunction != null) {
            this.firstFunction.setPrev(function);
        }
        this.firstFunction = function;
    }

    @Override
    public void generateCode(MethodBuilder mb) {
        throw new InternalCompilerError("Functions should be lambda lifted before code generation");
    }

    @Override
    public void validate(SSAValidationContext context) {
        SSAFunction function = this.firstFunction;
        while (function != null) {
            if (!(function.getTarget() instanceof BoundVar)) {
                throw new InternalCompilerError();
            }
            function.validate(context);
            function = function.getNext();
        }
    }

    @Override
    public void destroy() {
        SSAFunction function = this.firstFunction;
        while (function != null) {
            function.destroy();
            function = function.getNext();
        }
    }

    @Override
    public SSAStatement copy(CopyContext context) {
        LetFunctions result = new LetFunctions();
        SSAFunction function = this.firstFunction;
        while (function != null) {
            SSAFunction newFunction = function.copy(context);
            newFunction.setTarget(context.copy(function.getTarget()));
            result.addFunction(newFunction);
            function = function.getNext();
        }
        return result;
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
        SSAFunction function = this.firstFunction;
        while (function != null) {
            ((BoundVar)function.getTarget()).replace(vars, replacements);
            function.replace(vars, replacements);
            function = function.getNext();
        }
    }

    @Override
    public void addBoundVariablesTo(SSAValidationContext context) {
        SSAFunction function = this.firstFunction;
        while (function != null) {
            context.validBoundVariables.add((Object)((BoundVar)function.getTarget()));
            function = function.getNext();
        }
    }

    @Override
    public SSAFunction getFirstFunction() {
        return this.firstFunction;
    }

    @Override
    public void setFirstFunction(SSAFunction function) {
        this.firstFunction = function;
        if (function == null) {
            this.detach();
        }
    }

    @Override
    public void collectFreeVariables(SSAFunction parentFunction, ArrayList<ValRef> vars) {
        throw new InternalCompilerError("Should not be called for non-lambda-lifted functions.");
    }

    @Override
    public void lambdaLift(SSALambdaLiftingContext context) {
        boolean hasValues = false;
        boolean isRecursive = false;
        THashSet targets = new THashSet();
        ArrayList<ValRef> freeVars = new ArrayList<ValRef>();
        SSAFunction function = this.firstFunction;
        while (function != null) {
            hasValues |= function.getArity() == 0;
            function.lambdaLift(context);
            targets.add((Object)((BoundVar)function.getTarget()));
            function.collectFreeVariables(freeVars);
            function = function.getNext();
        }
        THashSet boundVars = new THashSet();
        ArrayList<BoundVar> boundVarsList = new ArrayList<BoundVar>(4);
        ArrayList<ValRef> newFreeVars = new ArrayList<ValRef>(freeVars.size());
        for (ValRef ref : freeVars) {
            BoundVar var = (BoundVar)ref.getBinding();
            if (targets.contains((Object)var)) {
                isRecursive = true;
                continue;
            }
            if (boundVars.add((Object)var)) {
                boundVarsList.add(var);
            }
            newFreeVars.add(ref);
        }
        BoundVar[] outVars = boundVarsList.toArray(new BoundVar[boundVarsList.size()]);
        freeVars = newFreeVars;
        THashMap varMap = new THashMap();
        THashMap inVarsMap = new THashMap();
        THashMap oldTargets = new THashMap();
        SSAFunction function2 = this.firstFunction;
        while (function2 != null) {
            THashMap map = new THashMap(2 * outVars.length);
            BoundVar[] inVars = new BoundVar[outVars.length];
            int i = 0;
            while (i < inVars.length) {
                inVars[i] = new BoundVar(outVars[i].getType());
                map.put((Object)outVars[i], (Object)inVars[i]);
                ++i;
            }
            inVarsMap.put((Object)function2, (Object)inVars);
            varMap.put((Object)function2, (Object)map);
            function2.addParametersInFront(inVars);
            SCLConstant functionConstant = new SCLConstant(context.createName(), function2.getType());
            context.addConstant(functionConstant);
            oldTargets.put((Object)function2, (Object)((BoundVar)function2.getTarget()));
            function2.setTarget(functionConstant);
            functionConstant.setDefinition(function2);
            functionConstant.setPrivate(true);
            function2 = function2.getNext();
        }
        function2 = this.firstFunction;
        while (function2 != null) {
            BoundVar oldTarget = (BoundVar)oldTargets.get((Object)function2);
            ValRef[] valRefArray = oldTarget.getOccurences();
            int n = valRefArray.length;
            int functionConstant = 0;
            while (functionConstant < n) {
                ValRef ref = valRefArray[functionConstant];
                SSAFunction parent = ref.getParentFunction();
                Val[] vars = (BoundVar[])inVarsMap.get((Object)parent);
                if (vars == null) {
                    vars = outVars;
                }
                if (vars.length > 0) {
                    ref.replaceByApply(function2.getTarget(), vars);
                } else {
                    ref.replaceBy(function2.getTarget());
                }
                ++functionConstant;
            }
            function2 = function2.getNext();
        }
        for (ValRef ref : freeVars) {
            BoundVar inVar = (BoundVar)ref.getBinding();
            if (targets.contains((Object)inVar)) continue;
            BoundVar outVar = (BoundVar)((THashMap)varMap.get((Object)ref.getParentFunction())).get((Object)inVar);
            ref.replaceBy(outVar);
        }
        this.detach();
        if (hasValues && isRecursive) {
            context.getErrorLog().log(this.recursiveGroupLocation, "Variables defined recursively must all be functions.");
        }
    }

    @Override
    public void simplify(SSASimplificationContext context) {
        SSAFunction function = this.firstFunction;
        while (function != null) {
            function.simplify(context);
            function = function.getNext();
        }
    }

    public void setRecursiveGroupLocation(long recursiveGroupLocation) {
        this.recursiveGroupLocation = recursiveGroupLocation;
    }
}

