/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.ssa.statements;

import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.codegen.continuations.ContRef;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.ssa.SSAExit;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.SSAStatement;
import org.simantics.scl.compiler.codegen.ssa.binders.BoundVarBinder;
import org.simantics.scl.compiler.codegen.ssa.binders.ValRefBinder;
import org.simantics.scl.compiler.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.codegen.ssa.exits.Switch;
import org.simantics.scl.compiler.codegen.ssa.statements.LetStatement;
import org.simantics.scl.compiler.codegen.utils.CopyContext;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.MultiFunction;

public class LetApply
extends LetStatement
implements ValRefBinder {
    private ValRef function;
    private ValRef[] parameters;
    Type effect;

    public LetApply(BoundVar target, Type effect, ValRef function, ValRef ... parameters) {
        super(target);
        this.setFunction(function);
        this.setParameters(parameters);
        this.effect = Types.canonical(effect);
    }

    public void push(MethodBuilder mb) {
        Val f = this.getFunction().getBinding();
        Val[] ps = ValRef.getBindings(this.getParameters());
        if (f instanceof Constant) {
            Constant cf = (Constant)f;
            Type returnType = cf.apply(mb, this.getFunction().getTypeParameters(), ps);
            if (Types.isBoxed(returnType)) {
                mb.unbox(this.target.getType());
            }
        } else {
            mb.push(f, f.getType());
            mb.pushBoxed(ps);
            mb.genericApply(ps.length);
            mb.unbox(this.target.getType());
        }
    }

    @Override
    public void generateCode(MethodBuilder mb) {
        if (!this.target.generateOnFly) {
            this.push(mb);
            mb.store(this.target);
        }
    }

    @Override
    public void toString(PrintingContext context) {
        if (this.determineGenerateOnFly()) {
            context.addInlineExpression(this.target, this);
        } else {
            context.indentation();
            context.append(this.target);
            context.append("(" + this.target.occurrenceCount() + ")");
            context.append(" = ");
            this.bodyToString(context);
            context.append('\n');
        }
    }

    public void bodyToString(PrintingContext context) {
        if (context.getErrorMarker() == this) {
            context.append("!> ");
        }
        if (this.hasEffect()) {
            context.append("<");
            context.append(this.effect);
            context.append("> ");
        }
        context.append(this.getFunction());
        ValRef[] valRefArray = this.getParameters();
        int n = valRefArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            context.append(' ');
            context.append(parameter);
            ++n2;
        }
    }

    @Override
    public String toString() {
        PrintingContext context = new PrintingContext();
        this.toString(context);
        return context.toString();
    }

    @Override
    public void validate(SSAValidationContext context) {
        MultiFunction mFun;
        context.validate(this.target);
        if (this.target.getParent() != this) {
            throw new InternalCompilerError();
        }
        context.validate(this.function);
        if (this.function.getParent() != this) {
            throw new InternalCompilerError();
        }
        ValRef[] valRefArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            context.validate(parameter);
            if (parameter.getParent() != this) {
                throw new InternalCompilerError();
            }
            ++n2;
        }
        try {
            mFun = Types.matchFunction(this.getFunction().getType(), this.getParameters().length);
        }
        catch (MatchException e) {
            context.setErrorMarker(this);
            throw new InternalCompilerError();
        }
        int i = 0;
        while (i < this.getParameters().length) {
            context.assertSubsumes(this, this.getParameters()[i].getType(), mFun.parameterTypes[i]);
            ++i;
        }
        context.assertSubsumes(this, this.target.getType(), mFun.returnType);
        context.assertEqualsEffect(this, this.effect, mFun.effect);
    }

    @Override
    public void destroy() {
        this.getFunction().remove();
        ValRef[] valRefArray = this.getParameters();
        int n = valRefArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            parameter.remove();
            ++n2;
        }
    }

    @Override
    public void simplify(SSASimplificationContext context) {
        if (this.target.hasNoOccurences() && !this.hasEffect()) {
            this.remove();
            context.markModified("LetApply.dead-let-statement");
            return;
        }
        Val functionVal = this.getFunction().getBinding();
        if (functionVal instanceof BoundVar) {
            BoundVarBinder parent_ = ((BoundVar)functionVal).parent;
            if (parent_ instanceof SSAFunction) {
                SSAFunction function = (SSAFunction)parent_;
                if (functionVal.hasMoreThanOneOccurences()) {
                    return;
                }
                if (this.getParameters().length < function.getArity()) {
                    return;
                }
                if (this.getParameters().length > function.getArity()) {
                    this.split(function.getArity());
                }
                this.inline(function);
                function.detach();
                context.markModified("LetApply.beta-lambda");
            } else if (parent_ instanceof LetApply) {
                boolean hasJustOneOccurence;
                LetApply apply = (LetApply)parent_;
                if (apply.hasEffect()) {
                    return;
                }
                boolean bl = hasJustOneOccurence = !functionVal.hasMoreThanOneOccurences();
                if (hasJustOneOccurence && apply.getParent() == this.getParent() || apply.isPartial()) {
                    if (hasJustOneOccurence) {
                        apply.detach();
                        this.setFunction(apply.getFunction());
                        this.setParameters(ValRef.concat(apply.getParameters(), this.getParameters()));
                    } else {
                        this.setFunction(apply.getFunction().copy());
                        this.setParameters(ValRef.concat(ValRef.copy(apply.getParameters()), this.getParameters()));
                    }
                    context.markModified("LetApply.merge-applications");
                }
            } else if (parent_ instanceof SSABlock) {
                SSABlock parent = this.getParent();
                if (parent_ != parent) {
                    return;
                }
                if (parent.getFirstStatement() != this) {
                    return;
                }
                if (!parent.hasMoreThanOneOccurences()) {
                    return;
                }
                if (functionVal.hasMoreThanOneOccurences()) {
                    return;
                }
                ContRef ref = parent.getOccurrence();
                while (ref != null) {
                    if (!(ref.getParent() instanceof Jump)) {
                        return;
                    }
                    ref = ref.getNext();
                }
                int position = 0;
                while (position < parent.getParameters().length) {
                    if (parent.getParameters()[position] == functionVal) break;
                    ++position;
                }
                if (position == parent.getParameters().length) {
                    throw new InternalCompilerError();
                }
                ContRef ref2 = parent.getOccurrence();
                while (ref2 != null) {
                    Jump jump = (Jump)ref2.getParent();
                    SSABlock block = jump.getParent();
                    BoundVar newTarget = new BoundVar(this.target.getType());
                    block.addStatement(new LetApply(newTarget, this.effect, jump.getParameter(position), ValRef.copy(this.parameters)));
                    jump.setParameter(position, newTarget.createOccurrence());
                    ref2 = ref2.getNext();
                }
                parent.setParameter(position, this.target);
                this.remove();
                context.markModified("LetApply.hoist-apply");
            }
        } else if (functionVal instanceof Constant) {
            ((Constant)functionVal).inline(context, this);
        }
    }

    public boolean isPartial() {
        return this.parameters.length < this.function.getBinding().getEffectiveArity();
    }

    public void removeDegenerated() {
        if (this.getParameters().length == 0) {
            this.target.replaceBy(this.getFunction());
            this.getFunction().remove();
            this.detach();
        }
    }

    public boolean determineGenerateOnFly() {
        if (this.hasEffect()) {
            return false;
        }
        ValRef ref = this.target.getOccurrence();
        if (ref == null || ref.getNext() != null) {
            return false;
        }
        ValRefBinder parent = ref.getParent();
        if (parent instanceof SSAStatement) {
            if (((SSAStatement)((Object)parent)).getParent() != this.getParent()) {
                return false;
            }
        } else if (parent instanceof SSAExit) {
            if (((SSAExit)((Object)parent)).getParent() != this.getParent()) {
                return false;
            }
            if (parent instanceof Switch) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void markGenerateOnFly() {
        this.target.generateOnFly = this.determineGenerateOnFly();
    }

    public ValRef getFunction() {
        return this.function;
    }

    public void setFunction(ValRef function) {
        this.function = function;
        function.setParent(this);
    }

    public ValRef[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ValRef[] parameters) {
        this.parameters = parameters;
        ValRef[] valRefArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            parameter.setParent(this);
            ++n2;
        }
    }

    @Override
    public SSAStatement copy(CopyContext context) {
        LetApply result = new LetApply(context.copy(this.target), this.effect, context.copy(this.function), context.copy(this.parameters));
        return result;
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
        this.target.replace(vars, replacements);
        this.function.replace(vars, replacements);
        this.effect = this.effect.replace(vars, replacements);
        ValRef[] valRefArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            parameter.replace(vars, replacements);
            ++n2;
        }
    }

    public void inline(SSAFunction function) {
        if (function.getArity() != this.parameters.length) {
            throw new InternalCompilerError();
        }
        SSABlock headBlock = this.getParent();
        SSAFunction thisFunction = headBlock.getParent();
        if (this.function.getTypeParameters().length > 0) {
            function.replace(function.getTypeParameters(), this.function.getTypeParameters());
        }
        if (this.getPrev() != null) {
            this.getPrev().setAsLastStatement();
        } else {
            headBlock.removeStatements();
        }
        SSABlock tailBlock = new SSABlock(new BoundVar[]{this.target});
        thisFunction.addBlock(tailBlock);
        SSAStatement stat = this.getNext();
        while (stat != null) {
            SSAStatement temp = stat.getNext();
            tailBlock.addStatement(stat);
            stat = temp;
        }
        tailBlock.setExit(headBlock.getExit());
        thisFunction.mergeBlocks(function);
        headBlock.setExit(new Jump(function.getFirstBlock().createOccurrence(), this.parameters));
        function.getReturnCont().replaceWith(tailBlock);
        this.function.remove();
    }

    @Override
    public void collectFreeVariables(SSAFunction parentFunction, ArrayList<ValRef> vars) {
        this.function.collectFreeVariables(parentFunction, vars);
        ValRef[] valRefArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            parameter.collectFreeVariables(parentFunction, vars);
            ++n2;
        }
    }

    @Override
    public void replaceByApply(ValRef valRef, Val newFunction, Type[] typeParameters, Val[] parameters) {
        if (this.function == valRef) {
            valRef.remove();
            this.setFunction(newFunction.createOccurrence(typeParameters));
            this.setParameters(ValRef.concat(ValRef.createOccurrences(parameters), this.parameters));
        } else {
            super.replaceByApply(valRef, newFunction, typeParameters, parameters);
        }
    }

    public void split(int arity) {
        BoundVar newVar;
        if (arity == this.parameters.length) {
            return;
        }
        if (arity > this.parameters.length) {
            throw new InternalCompilerError();
        }
        ValRef[] firstHalf = arity == 0 ? ValRef.EMPTY_ARRAY : Arrays.copyOf(this.parameters, arity);
        ValRef[] secondHalf = arity == this.parameters.length ? ValRef.EMPTY_ARRAY : Arrays.copyOfRange(this.parameters, arity, this.parameters.length);
        try {
            MultiFunction mfun = Types.matchFunction(this.function.getType(), arity);
            newVar = new BoundVar(mfun.returnType);
        }
        catch (MatchException e) {
            throw new InternalCompilerError();
        }
        LetApply newApply = new LetApply(this.target, this.effect, newVar.createOccurrence(), secondHalf);
        newApply.insertAfter(this);
        this.effect = Types.NO_EFFECTS;
        this.setTarget(newVar);
        this.setParameters(firstHalf);
    }

    public boolean hasEffect() {
        return this.effect != Types.NO_EFFECTS;
    }

    public void updateEffect() {
        try {
            MultiFunction mFun = Types.matchFunction(this.function.getType(), this.parameters.length);
            this.effect = mFun.effect;
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }

    @Override
    public void prepare(MethodBuilder mb) {
        this.function.getBinding().prepare(mb);
    }
}

