/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.ssa.exits;

import java.util.ArrayList;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.continuations.ContRef;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.ssa.SSAExit;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.binders.ValRefBinder;
import org.simantics.scl.compiler.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.codegen.utils.CopyContext;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.codegen.values.BooleanConstant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class If
extends SSAExit
implements ValRefBinder {
    private ValRef condition;
    private ContRef thenTarget;
    private ContRef elseTarget;

    public If(ValRef condition, ContRef thenTarget, ContRef elseTarget) {
        this.setCondition(condition);
        this.setThenTarget(thenTarget);
        this.setElseTarget(elseTarget);
    }

    public void setCondition(ValRef condition) {
        this.condition = condition;
        condition.setParent(this);
    }

    public void setThenTarget(ContRef thenTarget) {
        this.thenTarget = thenTarget;
        thenTarget.setParent(this);
    }

    public void setElseTarget(ContRef elseTarget) {
        this.elseTarget = elseTarget;
        elseTarget.setParent(this);
    }

    @Override
    public void generateCode(MethodBuilder mb) {
        CodeBuilder cb = mb.getCodeBuilder();
        mb.push(this.condition.getBinding(), Types.BOOLEAN);
        Label elseLabel = mb.getLabel(this.elseTarget.getBinding());
        cb.ifZeroComparisonBranch((Location)elseLabel, "==");
        mb.jump(this.thenTarget.getBinding());
        mb.ensureExists(this.elseTarget.getBinding());
    }

    @Override
    public void toString(PrintingContext context) {
        context.append("if ");
        context.append(this.condition);
        context.append(" then ");
        Cont thenCont = this.thenTarget.getBinding();
        if (thenCont instanceof SSABlock) {
            SSABlock thenBlock = (SSABlock)thenCont;
            if (thenCont.hasMoreThanOneOccurences()) {
                context.append(thenCont);
                context.addBlock(thenBlock);
                context.append(' ');
            } else {
                context.append('\n');
                thenBlock.bodyToString(context);
                context.indentation();
            }
        } else {
            context.append(thenCont);
            context.append(' ');
        }
        context.append("else ");
        Cont elseCont = this.elseTarget.getBinding();
        if (elseCont instanceof SSABlock) {
            SSABlock elseBlock = (SSABlock)elseCont;
            if (elseCont.hasMoreThanOneOccurences()) {
                context.append(elseCont);
                context.addBlock(elseBlock);
                context.append('\n');
            } else {
                context.append('\n');
                elseBlock.bodyToString(context);
            }
        } else {
            context.append(elseCont);
            context.append('\n');
        }
    }

    @Override
    public void validate(SSAValidationContext context) {
        context.validate(this.condition);
        context.validate(this.elseTarget);
        context.validate(this.thenTarget);
        if (this.condition.getParent() != this) {
            throw new InternalCompilerError();
        }
        if (this.elseTarget.getParent() != this) {
            throw new InternalCompilerError();
        }
        if (this.thenTarget.getParent() != this) {
            throw new InternalCompilerError();
        }
        context.assertEquals(this, this.condition.getType(), Types.BOOLEAN);
        context.assertEquals(this.elseTarget.getBinding().getArity(), 0);
        context.assertEquals(this.thenTarget.getBinding().getArity(), 0);
    }

    @Override
    public void destroy() {
        this.condition.remove();
        this.elseTarget.remove();
        this.thenTarget.remove();
    }

    @Override
    public SSAExit copy(CopyContext context) {
        return new If(context.copy(this.condition), context.copy(this.thenTarget), context.copy(this.elseTarget));
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
        this.condition.replace(vars, replacements);
    }

    @Override
    public void simplify(SSASimplificationContext context) {
        Val cond = this.condition.getBinding();
        if (cond instanceof BooleanConstant) {
            Jump newExit;
            if (((BooleanConstant)cond).getValue()) {
                newExit = new Jump(this.thenTarget, new ValRef[0]);
                this.elseTarget.remove();
            } else {
                newExit = new Jump(this.elseTarget, new ValRef[0]);
                this.thenTarget.remove();
            }
            this.condition.remove();
            this.getParent().setExit(newExit);
            context.markModified("beta-if");
        }
    }

    @Override
    public void collectFreeVariables(SSAFunction function, ArrayList<ValRef> vars) {
        this.condition.collectFreeVariables(function, vars);
    }

    @Override
    public Cont addParametersInFrontOf(ContRef contRef, Val[] newParameters, Val[] oldParameters, Cont proxy) {
        if (proxy == null) {
            proxy = contRef.getBinding().createProxy(this.getParent().getParent(), newParameters, oldParameters);
        }
        ContRef proxyRef = proxy.createOccurrence();
        if (this.thenTarget == contRef) {
            this.setThenTarget(proxyRef);
        } else {
            this.setElseTarget(proxyRef);
        }
        return proxy;
    }

    @Override
    public SSABlock[] getSuccessors() {
        Cont thenCont = this.thenTarget.getBinding();
        Cont elseCont = this.elseTarget.getBinding();
        if (thenCont instanceof SSABlock) {
            if (elseCont instanceof SSABlock) {
                return new SSABlock[]{(SSABlock)thenCont, (SSABlock)elseCont};
            }
            return new SSABlock[]{(SSABlock)thenCont};
        }
        if (elseCont instanceof SSABlock) {
            return new SSABlock[]{(SSABlock)elseCont};
        }
        return SSABlock.EMPTY_ARRAY;
    }
}

