/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.ssa;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.classes.InterfaceDescription;
import org.simantics.scl.compiler.codegen.classes.MethodDescription;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.CodeBuildingException;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.codegen.utils.NameMangling;
import org.simantics.scl.compiler.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.codegen.utils.SSALambdaLiftingContext;
import org.simantics.scl.compiler.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.codegen.values.JavaStaticMethod;
import org.simantics.scl.compiler.codegen.values.LocalVariableConstant;
import org.simantics.scl.compiler.codegen.values.NoRepConstant;
import org.simantics.scl.compiler.codegen.values.SCLConstant;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;

public class SSAModule {
    THashMap<Name, SCLConstant> functions = new THashMap();
    ArrayList<Tuple2> staticFields = new ArrayList();
    InterfaceDescription interfaceDescription;

    public SSAModule(InterfaceDescription interfaceDescription) {
        this.interfaceDescription = interfaceDescription;
    }

    public void put(Name name, SCLConstant function) {
        this.functions.put((Object)name, (Object)function);
    }

    public SCLConstant get(Name name) {
        return (SCLConstant)this.functions.get((Object)name);
    }

    public String toString() {
        final StringBuilder b = new StringBuilder();
        this.functions.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<Name, SCLConstant>(){

            public boolean execute(Name name, SCLConstant function) {
                b.append(name.name);
                b.append(" :: ");
                b.append(function.getType());
                b.append('\n');
                if (function.isPrivate()) {
                    b.append("PRIVATE ");
                }
                b.append(name);
                b.append(" =\n");
                PrintingContext context = new PrintingContext();
                context.indent();
                function.getDefinition().toString(context);
                b.append(context.toString());
                return true;
            }
        });
        return b.toString();
    }

    public void validate(SSAValidationContext context) {
        for (SCLConstant sCLConstant : this.functions.values()) {
        }
    }

    public void validate() {
        SSAValidationContext context = new SSAValidationContext();
        this.validate(context);
    }

    public boolean simplify(Environment environment, int phase) {
        SSASimplificationContext context = new SSASimplificationContext(this, environment, phase);
        SCLConstant[] sCLConstantArray = this.functions.values().toArray(new SCLConstant[this.functions.size()]);
        int n = sCLConstantArray.length;
        int n2 = 0;
        while (n2 < n) {
            SCLConstant function = sCLConstantArray[n2];
            if (this.functions.containsKey((Object)function.getName())) {
                if (function.isPrivate() && function.hasNoOccurences()) {
                    function.getDefinition().destroy();
                    this.functions.remove((Object)function.getName());
                    context.markModified("SSAModule.dead-function " + function.getName());
                } else {
                    function.simplify(context);
                }
            }
            ++n2;
        }
        return context.didModify();
    }

    public void generateCode(final ModuleBuilder moduleBuilder) throws CodeBuildingException {
        final String moduleClassName = moduleBuilder.getNamingPolicy().getModuleClassName();
        final ClassFile classFile = new ClassFile(moduleClassName, this.interfaceDescription.getSuperClass());
        classFile.setSourceFile("_SCL_Module");
        classFile.setTarget("1.6");
        this.functions.forEachValue((TObjectProcedure)new TObjectProcedure<SCLConstant>(){

            public boolean execute(SCLConstant function) {
                if (function.getBase() == null) {
                    Name name = function.getName();
                    SSAFunction definition = function.getDefinition();
                    function.setBase(new JavaStaticMethod(moduleClassName, NameMangling.mangle(name.name), definition.getEffect(), definition.getTypeParameters(), definition.getReturnType(), definition.getParameterTypes()));
                }
                return true;
            }
        });
        this.functions.forEachValue((TObjectProcedure)new TObjectProcedure<SCLConstant>(){

            public boolean execute(SCLConstant function) {
                JavaTypeTranslator javaTypeTranslator = moduleBuilder.getJavaTypeTranslator();
                SSAFunction def = function.getDefinition();
                MethodInfo methodInfo = classFile.addMethod(Modifiers.PUBLIC_STATIC, NameMangling.mangle(function.getName().name), javaTypeTranslator.getTypeDesc(def.getReturnCont()), JavaTypeTranslator.filterVoid(javaTypeTranslator.getTypeDescs(def.getParameters())));
                CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
                MethodBuilder mb = new MethodBuilder(moduleBuilder, codeBuilder);
                def.generateCode(mb);
                return true;
            }
        });
        JavaTypeTranslator javaTypeTranslator = moduleBuilder.getJavaTypeTranslator();
        for (Tuple2 tuple : this.staticFields) {
            classFile.addField(Modifiers.PUBLIC_STATIC, (String)tuple.c0, javaTypeTranslator.toTypeDesc((Type)tuple.c1));
        }
        this.createInterface(moduleBuilder, classFile);
        moduleBuilder.addClass(classFile);
    }

    private void createInterface(ModuleBuilder moduleBuilder, ClassFile classFile) throws CodeBuildingException {
        String moduleName = moduleBuilder.getNamingPolicy().getModuleName();
        JavaTypeTranslator javaTypeTranslator = moduleBuilder.getJavaTypeTranslator();
        for (String interfaceName : this.interfaceDescription.getInterfaces()) {
            classFile.addInterface(interfaceName);
        }
        for (MethodDescription methodDesc : this.interfaceDescription.getMethods()) {
            SCLConstant functionValue = (SCLConstant)this.functions.get((Object)Name.create(moduleName, methodDesc.getSclName()));
            if (functionValue == null) {
                throw new CodeBuildingException("Didn't find function " + methodDesc.getSclName());
            }
            Type returnType = methodDesc.getReturnType();
            Type[] parameterTypes = methodDesc.getParameterTypes();
            TypeDesc[] parameterTypeDescs = javaTypeTranslator.toTypeDescs(parameterTypes);
            MethodInfo mi = classFile.addMethod(methodDesc.getModifiers(), methodDesc.getJavaName(), javaTypeTranslator.toTypeDesc(returnType), JavaTypeTranslator.filterVoid(parameterTypeDescs));
            CodeBuilder cb = new CodeBuilder(mi);
            MethodBuilder mb = new MethodBuilder(moduleBuilder, cb);
            Val[] parameters = new Val[parameterTypes.length];
            int i = 0;
            int j = 0;
            while (i < parameters.length) {
                parameters[i] = parameterTypeDescs[i].equals((Object)TypeDesc.VOID) ? new NoRepConstant(parameterTypes[i]) : new LocalVariableConstant(parameterTypes[i], cb.getParameter(j++));
                ++i;
            }
            Type ret = functionValue.apply(mb, Type.EMPTY_ARRAY, parameters);
            if (returnType instanceof TVar) {
                mb.box(ret);
            }
            cb.returnValue(javaTypeTranslator.toTypeDesc(returnType));
        }
        MethodInfo mi = classFile.addConstructor(Modifiers.PUBLIC, Constants.EMPTY_TYPEDESC_ARRAY);
        CodeBuilder cb = new CodeBuilder(mi);
        cb.loadThis();
        cb.invokeSuperConstructor(Constants.EMPTY_TYPEDESC_ARRAY);
        cb.returnVoid();
    }

    public void markGenerateOnFly() {
        this.functions.forEachValue((TObjectProcedure)new TObjectProcedure<SCLConstant>(){

            public boolean execute(SCLConstant func) {
                func.getDefinition().markGenerateOnFly();
                return true;
            }
        });
    }

    public void addStaticField(Tuple2 tuple) {
        this.staticFields.add(tuple);
    }

    public SCLConstant remove(Name name) {
        return (SCLConstant)this.functions.remove((Object)name);
    }

    public void lambdaLift(ErrorLog errorLog) {
        SSALambdaLiftingContext context = new SSALambdaLiftingContext(this, errorLog);
        SCLConstant[] sCLConstantArray = this.functions.values().toArray(new SCLConstant[this.functions.size()]);
        int n = sCLConstantArray.length;
        int n2 = 0;
        while (n2 < n) {
            SCLConstant function = sCLConstantArray[n2];
            context.setParentName(function.getName());
            function.getDefinition().lambdaLift(context);
            ++n2;
        }
    }

    public void saveInlinableDefinitions() {
        for (SCLConstant function : this.functions.values()) {
            function.saveInlinableDefinition();
        }
    }
}

