/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.ssa;

import java.util.ArrayList;
import java.util.Arrays;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.continuations.ContRef;
import org.simantics.scl.compiler.codegen.continuations.ReturnCont;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.ssa.SSAStatement;
import org.simantics.scl.compiler.codegen.ssa.binders.BoundVarBinder;
import org.simantics.scl.compiler.codegen.ssa.binders.FunctionBinder;
import org.simantics.scl.compiler.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.codegen.ssa.statements.LetFunctions;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.CopyContext;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.Printable;
import org.simantics.scl.compiler.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.codegen.utils.SSALambdaLiftingContext;
import org.simantics.scl.compiler.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class SSAFunction
implements Printable,
BoundVarBinder {
    Val target;
    TVar[] typeParameters;
    Type effect;
    SSABlock firstBlock;
    SSABlock lastBlock;
    ReturnCont returnCont;
    FunctionBinder parent;
    SSAFunction prev;
    SSAFunction next;

    public SSAFunction(TVar[] typeParameters, Type effect, Type returnType) {
        this(typeParameters, effect, new ReturnCont(returnType));
    }

    public SSAFunction(TVar[] typeParameters, Type effect, ReturnCont returnCont) {
        this.typeParameters = typeParameters;
        this.returnCont = returnCont;
        this.effect = Types.canonical(effect);
        returnCont.setParent(this);
    }

    public Val getTarget() {
        return this.target;
    }

    public void setTarget(Val target) {
        this.target = target;
        if (target instanceof BoundVar) {
            ((BoundVar)target).parent = this;
        }
    }

    public void setTarget(BoundVar target) {
        this.target = target;
        target.parent = this;
    }

    public boolean hasEffect() {
        return this.effect != Types.NO_EFFECTS;
    }

    public void addBlock(SSABlock block) {
        block.parent = this;
        if (this.lastBlock == null) {
            this.firstBlock = this.lastBlock = block;
            block.prev = null;
            block.next = null;
        } else {
            this.lastBlock.next = block;
            block.prev = this.lastBlock;
            block.next = null;
            this.lastBlock = block;
        }
    }

    public void addBlockInFront(SSABlock block) {
        block.parent = this;
        if (this.firstBlock == null) {
            this.firstBlock = this.lastBlock = block;
            block.prev = null;
            block.next = null;
        } else {
            this.firstBlock.prev = block;
            block.next = this.firstBlock;
            block.prev = null;
            this.firstBlock = block;
        }
    }

    public ReturnCont getReturnCont() {
        return this.returnCont;
    }

    public TVar[] getTypeParameters() {
        return this.typeParameters;
    }

    public SSABlock getFirstBlock() {
        return this.firstBlock;
    }

    public void generateCode(MethodBuilder mb) {
        CodeBuilder cb = mb.getCodeBuilder();
        JavaTypeTranslator tt = mb.getJavaTypeTranslator();
        int i = 0;
        int j = 0;
        while (i < this.firstBlock.parameters.length) {
            if (!tt.toTypeDesc(this.firstBlock.parameters[i].getType()).equals((Object)TypeDesc.VOID)) {
                mb.setLocalVariable(this.firstBlock.parameters[i], cb.getParameter(j++));
            }
            ++i;
        }
        SSABlock block = this.firstBlock;
        while (block != null) {
            block.prepare(mb);
            block = block.next;
        }
        this.firstBlock.generateCode(mb);
    }

    @Override
    public void toString(PrintingContext context) {
        SSABlock block;
        context.indentation();
        if (this.typeParameters.length > 0) {
            context.append('<');
            boolean first = true;
            TVar[] tVarArray = this.typeParameters;
            int n = this.typeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                TVar var = tVarArray[n2];
                if (first) {
                    first = false;
                } else {
                    context.append(',');
                }
                context.append(var);
                ++n2;
            }
            context.append("> ");
        }
        if (this.hasEffect()) {
            context.append(this.effect);
            context.append(" ");
        }
        context.append("RETURNS ");
        context.append(this.returnCont.getType());
        context.append('\n');
        context.pushBlockQueue();
        context.addBlock(this.getFirstBlock());
        while ((block = context.pollBlock()) != null) {
            block.toString(context);
        }
        context.popBlockQueue();
    }

    public String toString() {
        PrintingContext context = new PrintingContext();
        this.toString(context);
        return context.toString();
    }

    public void validate(SSAValidationContext context) {
        if (this.target instanceof BoundVar && ((BoundVar)this.target).parent != this) {
            throw new InternalCompilerError();
        }
        TVar[] tVarArray = this.typeParameters;
        int n = this.typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            TVar var = tVarArray[n2];
            context.validTypeVariables.add((Object)var);
            ++n2;
        }
        context.validContinuations.add((Object)this.returnCont);
        SSABlock block = this.firstBlock;
        while (block != null) {
            context.validContinuations.add((Object)block);
            BoundVar[] boundVarArray = block.parameters;
            int n3 = block.parameters.length;
            n = 0;
            while (n < n3) {
                BoundVar parameter = boundVarArray[n];
                context.validBoundVariables.add((Object)parameter);
                ++n;
            }
            SSAStatement stat = block.firstStatement;
            while (stat != null) {
                stat.addBoundVariablesTo(context);
                stat = stat.next;
            }
            block = block.next;
        }
        block = this.firstBlock;
        while (block != null) {
            block.validate(context);
            block = block.next;
        }
        context.validate(this.returnCont);
    }

    public void simplify(SSASimplificationContext context) {
        SSABlock block = this.firstBlock;
        while (block != null) {
            block.simplify(context);
            block = block.next;
        }
        if (this.firstBlock == this.lastBlock && this.firstBlock.firstStatement == this.firstBlock.lastStatement && this.firstBlock.firstStatement instanceof LetFunctions) {
            this.simplifySingleLambda(context);
        }
    }

    private void simplifySingleLambda(SSASimplificationContext context) {
        LetFunctions letF = (LetFunctions)this.firstBlock.firstStatement;
        SSAFunction f = letF.getFirstFunction();
        if (f.getNext() != null) {
            return;
        }
        Val fVal = f.getTarget();
        if (!this.firstBlock.exit.isJump(this.getReturnCont(), fVal)) {
            return;
        }
        if (fVal.hasMoreThanOneOccurences()) {
            return;
        }
        if (this.hasEffect()) {
            return;
        }
        SSABlock block = f.firstBlock;
        while (block != null) {
            block.parent = this;
            block = block.next;
        }
        this.lastBlock.next = f.firstBlock;
        f.firstBlock.prev = this.lastBlock;
        this.lastBlock = f.lastBlock;
        this.firstBlock.lastStatement = null;
        this.firstBlock.firstStatement = null;
        this.setReturnCont(f.getReturnCont());
        this.effect = f.effect;
        IVal[] newParameters = BoundVar.copy(f.firstBlock.parameters);
        this.firstBlock.setParameters(BoundVar.concat(this.getParameters(), (BoundVar[])newParameters));
        this.firstBlock.setExit(new Jump(f.firstBlock.createOccurrence(), ValRef.createOccurrences(newParameters)));
        context.markModified("SSAFunction.simplify-simple-lambda");
    }

    public void setReturnCont(ReturnCont returnCont) {
        this.returnCont = returnCont;
        returnCont.setParent(this);
    }

    public ValRef isEqualToConstant() {
        if (this.firstBlock.parameters.length > 0) {
            return null;
        }
        if (this.firstBlock != this.lastBlock) {
            return null;
        }
        if (this.firstBlock.firstStatement != null) {
            return null;
        }
        if (!(this.firstBlock.exit instanceof Jump)) {
            return null;
        }
        Jump exit = (Jump)this.firstBlock.exit;
        if (exit.getTarget().getBinding() != this.returnCont) {
            return null;
        }
        return exit.getParameters()[0];
    }

    public BoundVar[] getParameters() {
        return this.firstBlock.parameters;
    }

    public Type[] getParameterTypes() {
        return Types.getTypes(this.firstBlock.parameters);
    }

    public int getArity() {
        return this.firstBlock.parameters.length;
    }

    public void markGenerateOnFly() {
        SSABlock block = this.firstBlock;
        while (block != null) {
            block.markGenerateOnFly();
            block = block.next;
        }
    }

    public SSAFunction copy(CopyContext context) {
        SSAFunction newFunction = new SSAFunction(this.typeParameters, this.effect, context.copy(this.returnCont));
        SSABlock block = this.firstBlock;
        while (block != null) {
            newFunction.addBlock(context.copy(block));
            block = block.next;
        }
        return newFunction;
    }

    public SSAFunction copy() {
        return this.copy(new CopyContext());
    }

    public void replace(TVar[] vars, Type[] replacements) {
        this.returnCont.replace(vars, replacements);
        SSABlock block = this.firstBlock;
        while (block != null) {
            block.replace(vars, replacements);
            block = block.next;
        }
    }

    public void setTypeParameters(TVar[] typeParameters) {
        this.typeParameters = typeParameters;
    }

    public Type getType() {
        Type type = this.returnCont.getType();
        type = Types.functionE(Types.getTypes(this.firstBlock.parameters), this.effect, type);
        type = Types.forAll(this.typeParameters, type);
        return type;
    }

    public void mergeBlocks(SSAFunction function) {
        SSABlock block = function.firstBlock;
        while (block != null) {
            SSABlock next = block.next;
            this.addBlock(block);
            block = next;
        }
    }

    public Type getReturnType() {
        return this.returnCont.getType();
    }

    public void destroy() {
        SSABlock block = this.firstBlock;
        while (block != null) {
            block.destroy();
            block = block.next;
        }
    }

    public void detach() {
        if (this.prev == null) {
            this.parent.setFirstFunction(this.next);
        } else {
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
    }

    public void remove() {
        this.destroy();
        this.detach();
    }

    public void addSibling(SSAFunction function) {
        function.parent = this.parent;
        function.next = this.next;
        function.prev = this;
        this.next.prev = function;
        this.next = function;
    }

    public SSAFunction getNext() {
        return this.next;
    }

    public void setParent(FunctionBinder parent) {
        this.parent = parent;
    }

    public void setPrev(SSAFunction function) {
        this.prev = function;
    }

    public void setNext(SSAFunction function) {
        this.next = function;
    }

    public void collectFreeVariables(ArrayList<ValRef> vars) {
        SSABlock block = this.firstBlock;
        while (block != null) {
            block.collectFreeVariables(this, vars);
            block = block.next;
        }
    }

    @Override
    public SSAFunction getParentFunction() {
        return this.parent.getParentFunction();
    }

    public FunctionBinder getParent() {
        return this.parent;
    }

    public void lambdaLift(SSALambdaLiftingContext context) {
        SSABlock block = this.firstBlock;
        while (block != null) {
            block.lambdaLift(context);
            block = block.next;
        }
    }

    public void addParametersInFront(BoundVar[] parameters) {
        Cont proxy = null;
        ContRef ref = this.firstBlock.getOccurrence();
        while (ref != null) {
            proxy = ref.addParametersInFront(parameters, this.firstBlock.parameters, proxy);
            ref = ref.getNext();
        }
        this.firstBlock.parameters = BoundVar.concat(parameters, this.firstBlock.parameters);
        BoundVar[] boundVarArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            BoundVar parameter = boundVarArray[n2];
            parameter.parent = this.firstBlock;
            ++n2;
        }
    }

    public void apply(ValRef[] parameters) {
        if (parameters.length == 0) {
            return;
        }
        if (this.firstBlock.hasNoOccurences()) {
            BoundVar[] vars = this.firstBlock.getParameters();
            int i = 0;
            while (i < parameters.length) {
                vars[i].replaceBy(parameters[i]);
                ++i;
            }
            this.firstBlock.setParameters(Arrays.copyOfRange(vars, parameters.length, vars.length));
        } else {
            IVal[] newVars = new BoundVar[this.getArity() - parameters.length];
            SSABlock block = new SSABlock((BoundVar[])newVars);
            block.setExit(new Jump(this.firstBlock.createOccurrence(), ValRef.concat(ValRef.copy(parameters), ValRef.createOccurrences(newVars))));
            this.addBlockInFront(block);
        }
    }

    public void applyTypes(Type[] types) {
        if (types.length == 0) {
            return;
        }
        if (types.length == this.typeParameters.length) {
            this.replace(this.typeParameters, types);
            this.typeParameters = TVar.EMPTY_ARRAY;
        } else {
            this.replace(Arrays.copyOf(this.typeParameters, types.length), types);
            this.typeParameters = Arrays.copyOfRange(this.typeParameters, types.length, this.typeParameters.length);
        }
    }

    public boolean isSimpleEnoughForInline() {
        return this.firstBlock == this.lastBlock && (this.firstBlock.firstStatement == null || this.firstBlock.firstStatement == this.firstBlock.lastStatement && this.firstBlock.firstStatement instanceof LetApply);
    }

    public Type getEffect() {
        return this.effect;
    }
}

