/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.ssa;

import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.continuations.BranchRef;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.continuations.ContRef;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSAExit;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.SSAStatement;
import org.simantics.scl.compiler.codegen.ssa.binders.BoundVarBinder;
import org.simantics.scl.compiler.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.codegen.ssa.exits.Switch;
import org.simantics.scl.compiler.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.codegen.utils.CopyContext;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.Printable;
import org.simantics.scl.compiler.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.codegen.utils.SSALambdaLiftingContext;
import org.simantics.scl.compiler.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.codegen.values.SCLConstant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class SSABlock
extends Cont
implements Printable,
BoundVarBinder {
    public static final SSABlock[] EMPTY_ARRAY = new SSABlock[0];
    BoundVar[] parameters;
    SSAFunction parent;
    SSABlock prev;
    SSABlock next;
    SSAStatement firstStatement;
    SSAStatement lastStatement;
    SSAExit exit;

    public SSABlock(Type ... parameterTypes) {
        this.parameters = new BoundVar[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            BoundVar parameter;
            this.parameters[i] = parameter = new BoundVar(parameterTypes[i]);
            parameter.parent = this;
            ++i;
        }
    }

    public SSABlock(BoundVar[] parameters) {
        this.parameters = parameters;
        BoundVar[] boundVarArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            BoundVar parameter = boundVarArray[n2];
            parameter.parent = this;
            ++n2;
        }
    }

    public SSAFunction getParent() {
        return this.parent;
    }

    public SSABlock getNext() {
        return this.next;
    }

    public SSABlock getPrev() {
        return this.prev;
    }

    public SSAExit getExit() {
        return this.exit;
    }

    public void removeStatements() {
        this.firstStatement = null;
        this.lastStatement = null;
    }

    @Override
    public int getArity() {
        return this.parameters.length;
    }

    public int getStatementCount() {
        int count = 0;
        SSAStatement stat = this.firstStatement;
        while (stat != null) {
            ++count;
            stat = stat.next;
        }
        return count;
    }

    @Override
    public Type getParameterType(int parameterId) {
        return this.parameters[parameterId].getType();
    }

    public Type[] getParameterTypes() {
        return Types.getTypes(this.parameters);
    }

    public BoundVar[] getParameters() {
        return this.parameters;
    }

    public void setExit(SSAExit exit) {
        this.exit = exit;
        exit.parent = this;
    }

    public void detach() {
        if (this.prev == null) {
            this.parent.firstBlock = this.next;
        } else {
            this.prev.next = this.next;
        }
        if (this.next == null) {
            this.parent.lastBlock = this.prev;
        } else {
            this.next.prev = this.prev;
        }
        if (this.parent.firstBlock == null) {
            throw new InternalCompilerError();
        }
    }

    public void remove() {
        this.detach();
        this.destroy();
    }

    public void destroy() {
        SSAStatement statement = this.firstStatement;
        while (statement != null) {
            statement.destroy();
            statement = statement.next;
        }
        this.exit.destroy();
    }

    public void addStatement(SSAStatement stat) {
        stat.parent = this;
        if (this.lastStatement == null) {
            this.firstStatement = this.lastStatement = stat;
            stat.prev = null;
            stat.next = null;
        } else {
            this.lastStatement.next = stat;
            stat.prev = this.lastStatement;
            stat.next = null;
            this.lastStatement = stat;
        }
    }

    public void generateCode(MethodBuilder mb) {
        mb.setLocation(this);
        SSAStatement stat = this.firstStatement;
        while (stat != null) {
            stat.generateCode(mb);
            stat = stat.next;
        }
        this.exit.generateCode(mb);
    }

    @Override
    public void toString(PrintingContext context) {
        context.indentation();
        context.append(this);
        context.append("(" + this.occurrenceCount() + ")");
        this.parametersToString(context);
        context.append(" =\n");
        this.bodyToString(context);
    }

    public void parametersToString(PrintingContext context) {
        BoundVar[] boundVarArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            BoundVar parameter = boundVarArray[n2];
            context.append(' ');
            if (parameter.hasNoOccurences()) {
                context.append('_');
            } else {
                context.append(parameter);
            }
            ++n2;
        }
    }

    public void bodyToString(PrintingContext context) {
        context.indent();
        SSAStatement statement = this.firstStatement;
        while (statement != null) {
            statement.toString(context);
            statement = statement.next;
        }
        context.indentation();
        this.exit.toString(context);
        context.dedent();
    }

    public void validate(SSAValidationContext context) {
        if (this.exit.getParent() != this) {
            throw new InternalCompilerError();
        }
        BoundVar[] boundVarArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            BoundVar parameter = boundVarArray[n2];
            context.validate(parameter);
            if (parameter.parent != this) {
                throw new InternalCompilerError();
            }
            ++n2;
        }
        SSAStatement statement = this.firstStatement;
        while (statement != null) {
            if (statement.getParent() != this) {
                throw new InternalCompilerError();
            }
            statement.validate(context);
            statement = statement.next;
        }
        this.exit.validate(context);
        SSAStatement last = this.firstStatement;
        if (last != null) {
            while (last.next != null) {
                last = last.next;
            }
        }
        if (last != this.lastStatement) {
            throw new InternalCompilerError();
        }
    }

    public void simplify(SSASimplificationContext context) {
        if (this.hasNoOccurences() && this.parent.firstBlock != this) {
            this.remove();
            context.markModified("dead-block");
            return;
        }
        this.tryToImproveParameters(context);
        SSAStatement statement = this.firstStatement;
        while (statement != null) {
            statement.simplify(context);
            statement = statement.next;
        }
        this.exit.simplify(context);
        if (this.exit instanceof Switch && this.simplifySwitch()) {
            context.markModified("beta-switch");
        }
        if (this.exit instanceof Jump) {
            if (this.firstStatement == null && this.parent.firstBlock != this) {
                if (this.etaBlock(context)) {
                    context.markModified("eta-block");
                    return;
                }
                if (this.inlineJump()) {
                    context.markModified("beta-block");
                    return;
                }
            } else {
                if (this.optimizeTailSelfCall()) {
                    context.markModified("simplify-tail-call");
                    return;
                }
                if (this.inlineJump()) {
                    context.markModified("beta-block");
                    return;
                }
            }
        }
    }

    private void tryToImproveParameters(SSASimplificationContext context) {
        if (this.parent.firstBlock == this) {
            return;
        }
        if (this.parameters.length == 0) {
            return;
        }
        ContRef ref = this.getOccurrence();
        while (ref != null) {
            if (!(ref.getParent() instanceof Jump)) {
                return;
            }
            ref = ref.getNext();
        }
        boolean modified = false;
        int i = 0;
        while (i < this.parameters.length) {
            if (this.tryToImproveParameter(i)) {
                --i;
                modified = true;
            }
            ++i;
        }
        if (modified) {
            context.markModified("improve-parameters");
        }
    }

    private boolean tryToImproveParameter(int position) {
        Jump jump;
        BoundVar parameter = this.parameters[position];
        Val constant = null;
        ValRef constantRef = null;
        ContRef ref = this.getOccurrence();
        while (ref != null) {
            jump = (Jump)ref.getParent();
            ValRef valRef = jump.getParameters()[position];
            Val val = valRef.getBinding();
            if (val != parameter) {
                if (constant == null) {
                    constant = val;
                    constantRef = valRef;
                } else if (val != constant) {
                    return false;
                }
            }
            ref = ref.getNext();
        }
        if (constant == null) {
            return false;
        }
        parameter.replaceBy(constantRef);
        ref = this.getOccurrence();
        while (ref != null) {
            jump = (Jump)ref.getParent();
            jump.setParameters(SSABlock.removeAt(jump.getParameters(), position));
            ref = ref.getNext();
        }
        this.parameters = SSABlock.removeAt(this.parameters, position);
        return true;
    }

    private static BoundVar[] removeAt(BoundVar[] vars, int pos) {
        BoundVar[] result = new BoundVar[vars.length - 1];
        int i = 0;
        while (i < pos) {
            result[i] = vars[i];
            ++i;
        }
        i = pos + 1;
        while (i < vars.length) {
            result[i - 1] = vars[i];
            ++i;
        }
        return result;
    }

    private static ValRef[] removeAt(ValRef[] vars, int pos) {
        ValRef[] result = new ValRef[vars.length - 1];
        int i = 0;
        while (i < pos) {
            result[i] = vars[i];
            ++i;
        }
        vars[pos].remove();
        i = pos + 1;
        while (i < vars.length) {
            result[i - 1] = vars[i];
            ++i;
        }
        return result;
    }

    private boolean optimizeTailSelfCall() {
        Jump jump = (Jump)this.exit;
        if (jump.getTarget().getBinding() != this.parent.returnCont) {
            return false;
        }
        if (jump.getParameters().length != 1) {
            return false;
        }
        if (this.lastStatement == null || !(this.lastStatement instanceof LetApply)) {
            return false;
        }
        LetApply apply = (LetApply)this.lastStatement;
        SSABlock initialBlock = this.parent.firstBlock;
        if (initialBlock.parameters.length != apply.getParameters().length) {
            return false;
        }
        Val function = apply.getFunction().getBinding();
        if (function != this.parent.target) {
            return false;
        }
        apply.detach();
        apply.getFunction().remove();
        jump.getTarget().remove();
        jump.setTarget(initialBlock.createOccurrence());
        jump.setParameters(apply.getParameters());
        return true;
    }

    private boolean etaBlock(SSASimplificationContext context) {
        Jump jump = (Jump)this.exit;
        if (this.parameters.length != jump.getParameters().length) {
            return false;
        }
        int i = 0;
        while (i < this.parameters.length) {
            if (this.parameters[i] != jump.getParameters()[i].getBinding() || this.parameters[i].hasMoreThanOneOccurences()) {
                return false;
            }
            ++i;
        }
        this.replaceWith(jump.getTarget().getBinding());
        this.remove();
        return true;
    }

    private boolean simplifySwitch() {
        Switch sw = (Switch)this.exit;
        ValRef scrutineeRef = sw.getScrutinee();
        Val scrutinee = scrutineeRef.getBinding();
        if (scrutinee instanceof BoundVar) {
            BoundVarBinder parent = ((BoundVar)scrutinee).parent;
            if (!(parent instanceof LetApply)) {
                return false;
            }
            LetApply apply = (LetApply)parent;
            Val function = apply.getFunction().getBinding();
            if (!(function instanceof Constant) || function instanceof SCLConstant) {
                return false;
            }
            BranchRef[] branchRefArray = sw.getBranches();
            int n = branchRefArray.length;
            int n2 = 0;
            while (n2 < n) {
                BranchRef branch = branchRefArray[n2];
                if (branch.constructor == function) {
                    sw.destroy();
                    this.setExit(new Jump(branch.cont.getBinding().createOccurrence(), ValRef.copy(apply.getParameters())));
                    return true;
                }
                ++n2;
            }
        } else if (scrutinee instanceof Constant && sw.getBranches().length == 1) {
            BranchRef branch = sw.getBranches()[0];
            if (branch.constructor == scrutinee) {
                sw.destroy();
                this.setExit(new Jump(branch.cont.getBinding().createOccurrence(), new ValRef[0]));
            }
        }
        return false;
    }

    private boolean inlineJump() {
        Jump jump = (Jump)this.exit;
        Cont target = jump.getTarget().getBinding();
        if (!(target instanceof SSABlock)) {
            return false;
        }
        if (target.hasMoreThanOneOccurences()) {
            return false;
        }
        SSABlock block = (SSABlock)target;
        if (block == this.parent.firstBlock || block == this) {
            return false;
        }
        this.mergeStatements(block);
        int i = 0;
        while (i < jump.getParameters().length) {
            block.parameters[i].replaceBy(jump.getParameters()[i]);
            ++i;
        }
        block.detach();
        jump.destroy();
        this.setExit(block.exit);
        return true;
    }

    private void mergeStatements(SSABlock block) {
        SSAStatement stat = block.firstStatement;
        while (stat != null) {
            SSAStatement next = stat.next;
            this.addStatement(stat);
            stat = next;
        }
    }

    public String toString() {
        PrintingContext context = new PrintingContext();
        this.toString(context);
        return context.toString();
    }

    public void markGenerateOnFly() {
        SSAStatement stat = this.firstStatement;
        while (stat != null) {
            stat.markGenerateOnFly();
            stat = stat.next;
        }
    }

    @Override
    public SSABlock copy(CopyContext context) {
        SSABlock newBlock = new SSABlock(context.copy(this.parameters));
        context.put(this, newBlock);
        SSAStatement statement = this.firstStatement;
        while (statement != null) {
            newBlock.addStatement(statement.copy(context));
            statement = statement.next;
        }
        newBlock.setExit(this.exit.copy(context));
        return newBlock;
    }

    public void setParameters(BoundVar[] parameters) {
        BoundVar[] boundVarArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            BoundVar parameter = boundVarArray[n2];
            parameter.parent = this;
            ++n2;
        }
        this.parameters = parameters;
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
        BoundVar[] boundVarArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            BoundVar parameter = boundVarArray[n2];
            parameter.replace(vars, replacements);
            ++n2;
        }
        SSAStatement statement = this.firstStatement;
        while (statement != null) {
            statement.replace(vars, replacements);
            statement = statement.next;
        }
        this.exit.replace(vars, replacements);
    }

    public void collectFreeVariables(SSAFunction function, ArrayList<ValRef> vars) {
        SSAStatement statement = this.firstStatement;
        while (statement != null) {
            statement.collectFreeVariables(function, vars);
            statement = statement.next;
        }
        this.exit.collectFreeVariables(function, vars);
    }

    @Override
    public SSAFunction getParentFunction() {
        return this.parent;
    }

    public void lambdaLift(SSALambdaLiftingContext context) {
        SSAStatement statement = this.firstStatement;
        while (statement != null) {
            statement.lambdaLift(context);
            statement = statement.next;
        }
    }

    public SSAStatement getFirstStatement() {
        return this.firstStatement;
    }

    public void setParameter(int position, BoundVar target) {
        this.parameters[position] = target;
        target.parent = this;
    }

    public void prepare(MethodBuilder mb) {
        SSAStatement stat = this.firstStatement;
        while (stat != null) {
            stat.prepare(mb);
            stat = stat.next;
        }
        this.exit.prepare(mb);
    }
}

