/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.references;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.binders.BoundVarBinder;
import org.simantics.scl.compiler.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;

public class BoundVar
extends Val {
    public BoundVarBinder parent;
    Type type;
    String label;
    public boolean generateOnFly;

    public BoundVar(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void push(MethodBuilder mb) {
        if (this.generateOnFly) {
            ((LetApply)this.parent).push(mb);
        } else if (!mb.getJavaTypeTranslator().toTypeDesc(this.type).equals((Object)TypeDesc.VOID)) {
            mb.getCodeBuilder().loadLocal(mb.getLocalVariable(this));
        }
    }

    @Override
    public BoundVar copy() {
        return new BoundVar(this.type);
    }

    public void replace(TVar[] vars, Type[] replacements) {
        this.type = this.type.replace(vars, replacements);
    }

    public SSAFunction getFunctionParent() {
        return this.parent.getParentFunction();
    }

    public static BoundVar[] concat(BoundVar[] a, BoundVar[] b) {
        BoundVar[] result = new BoundVar[a.length + b.length];
        int l = a.length;
        int i = 0;
        while (i < l) {
            result[i] = a[i];
            ++i;
        }
        i = 0;
        while (i < b.length) {
            result[i + l] = b[i];
            ++i;
        }
        return result;
    }

    public BoundVarBinder getParent() {
        return this.parent;
    }

    @Override
    public int getEffectiveArity() {
        if (this.parent instanceof SSAFunction) {
            SSAFunction function = (SSAFunction)this.parent;
            int arity = function.getArity();
            if (function.hasEffect()) {
                ++arity;
            }
            return arity;
        }
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classLoader) {
        throw new UnsupportedOperationException();
    }

    public static BoundVar[] copy(BoundVar[] vars) {
        BoundVar[] result = new BoundVar[vars.length];
        int i = 0;
        while (i < vars.length) {
            result[i] = new BoundVar(vars[i].getType());
            ++i;
        }
        return result;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }
}

