/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.continuations;

import org.simantics.scl.compiler.codegen.continuations.ContRef;
import org.simantics.scl.compiler.codegen.continuations.ICont;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.codegen.utils.CopyContext;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;

public abstract class Cont
implements ICont {
    ContRef occurrence;

    @Override
    public ContRef createOccurrence() {
        return new ContRef(this);
    }

    public void replaceWith(Cont other) {
        ContRef cur = this.occurrence;
        if (cur != null) {
            while (true) {
                cur.binding = other;
                if (cur.next == null) break;
                cur = cur.next;
            }
            cur.next = other.occurrence;
            if (other.occurrence != null) {
                other.occurrence.prev = cur;
            }
            other.occurrence = this.occurrence;
            this.occurrence = null;
        }
    }

    @Override
    public abstract int getArity();

    @Override
    public abstract Type getParameterType(int var1);

    public int occurrenceCount() {
        int count = 0;
        ContRef ref = this.occurrence;
        while (ref != null) {
            ++count;
            ref = ref.next;
        }
        return count;
    }

    public boolean hasMoreThanOneOccurences() {
        return this.occurrence != null && this.occurrence.next != null;
    }

    public boolean hasNoOccurences() {
        return this.occurrence == null;
    }

    public abstract Cont copy(CopyContext var1);

    public abstract void replace(TVar[] var1, Type[] var2);

    public ContRef getOccurrence() {
        return this.occurrence;
    }

    public Cont createProxy(SSAFunction function, Val[] newParameters, Val[] oldParameters) {
        IVal[] proxyParameters = new BoundVar[oldParameters.length];
        int i = 0;
        while (i < oldParameters.length) {
            proxyParameters[i] = new BoundVar(oldParameters[i].getType());
            ++i;
        }
        SSABlock block = new SSABlock((BoundVar[])proxyParameters);
        function.addBlock(block);
        block.setExit(new Jump(this.createOccurrence(), ValRef.concat(ValRef.createOccurrences(newParameters), ValRef.createOccurrences(proxyParameters))));
        return block;
    }
}

