/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.analysis;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.codegen.continuations.ContRef;
import org.simantics.scl.compiler.codegen.references.BoundVar;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.SSAStatement;
import org.simantics.scl.compiler.codegen.ssa.binders.ValRefBinder;
import org.simantics.scl.compiler.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.codegen.values.SCLConstant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Name;

public abstract class StatementBrowser {
    THashSet<SSABlock> visited;
    THashMap<SSABlock, SSAStatement> loopPos;
    SSAStatement fromStatement;
    SSABlock fromBlock;
    boolean stopBrowse = false;
    private static final Name BUILD = Name.create("Prelude", "build");

    protected void stopBrowse() {
        this.stopBrowse = true;
    }

    public boolean isStopped() {
        return this.stopBrowse;
    }

    public void browseBetween(SSAStatement from, SSAStatement to) {
        SSABlock toBlock = to.getParent();
        if (from.getParent() == toBlock) {
            SSAStatement cur = from.getNext();
            while (cur != to) {
                if (cur == null) {
                    StatementBrowser.dominationError();
                }
                this.visitStatement(cur);
                if (this.stopBrowse) {
                    return;
                }
                cur = cur.getNext();
            }
        } else {
            SSAStatement cur = to.getPrev();
            while (cur != null) {
                this.visitStatement(cur);
                if (this.stopBrowse) {
                    return;
                }
                cur = cur.getPrev();
            }
            this.visited = new THashSet();
            this.fromStatement = from;
            this.fromBlock = from.getParent();
            this.loopPos = new THashMap();
            this.loopPos.put((Object)toBlock, (Object)to);
            this.browsePredecessors(toBlock);
        }
    }

    private void browseBetweenRec(SSAStatement to) {
        SSABlock toBlock = to.getParent();
        if (this.fromBlock == toBlock) {
            SSAStatement cur = this.fromStatement.getNext();
            while (cur != to) {
                if (cur == null) {
                    StatementBrowser.dominationError();
                }
                this.visitStatement(cur);
                if (this.stopBrowse) {
                    return;
                }
                cur = cur.getNext();
            }
        } else {
            SSAStatement cur = to.getPrev();
            while (cur != null) {
                this.visitStatement(cur);
                if (this.stopBrowse) {
                    return;
                }
                cur = cur.getPrev();
            }
            this.loopPos.put((Object)toBlock, (Object)to);
            this.browsePredecessors(to.getParent());
        }
    }

    private void browsePredecessors(SSABlock block) {
        ContRef contRef = block.getOccurrence();
        while (contRef != null) {
            this.browse(contRef.getParent().getParent());
            if (this.stopBrowse) {
                return;
            }
            contRef = contRef.getNext();
        }
    }

    private void browse(SSABlock block) {
        if (!this.visited.add((Object)block)) {
            return;
        }
        if (block == this.fromBlock) {
            SSAStatement cur = this.fromStatement.getNext();
            while (cur != null) {
                this.visitStatement(cur);
                if (this.stopBrowse) {
                    return;
                }
                cur = cur.getNext();
            }
            return;
        }
        if (this.loopPos.contains((Object)block)) {
            this.handleLoop(block, (SSAStatement)this.loopPos.get((Object)block));
            return;
        }
        SSAStatement cur = block.getFirstStatement();
        while (cur != null) {
            this.visitStatement(cur);
            if (this.stopBrowse) {
                return;
            }
            cur = cur.getNext();
        }
        this.browsePredecessors(block);
        if (this.stopBrowse) {
            return;
        }
        if (block.getPrev() == null) {
            Val functionTarget;
            SSAFunction function = block.getParent();
            if (function == this.fromBlock.getParent()) {
                StatementBrowser.dominationError();
            }
            if ((functionTarget = function.getTarget()) instanceof BoundVar) {
                this.browseFunction((BoundVar)functionTarget, function.getArity());
            } else {
                StatementBrowser.dominationError();
            }
        }
    }

    private static void dominationError() {
        throw new InternalCompilerError("Statement 'from' does not dominate the statement 'to'.");
    }

    protected void browseFunction(BoundVar function, int arity) {
        ValRef cur = function.getOccurrence();
        while (cur != null) {
            ValRefBinder binder = cur.getParent();
            if (binder instanceof LetApply) {
                this.browseApply((LetApply)binder, cur, arity);
            } else {
                this.unanalyzedBrowse();
            }
            if (this.stopBrowse) {
                return;
            }
            cur = cur.getNext();
        }
    }

    private static boolean callsOnlyOnce(Name name, int arity) {
        if (name == BUILD) {
            return arity == 1;
        }
        return false;
    }

    protected void browseApply(LetApply apply, ValRef functionRef, int arity) {
        ValRef applyFunctionRef = apply.getFunction();
        if (applyFunctionRef == functionRef) {
            if (apply.getParameters().length == arity) {
                this.browseBetweenRec(apply);
            } else {
                this.unanalyzedBrowse();
            }
        } else {
            Val applyFunction = applyFunctionRef.getBinding();
            if (!(applyFunction instanceof SCLConstant)) {
                this.unanalyzedBrowse();
                return;
            }
            Name name = ((SCLConstant)applyFunction).getName();
            if (StatementBrowser.callsOnlyOnce(name, arity)) {
                this.browseBetweenRec(apply);
            } else {
                this.unanalyzedBrowse();
            }
        }
    }

    protected void unanalyzedBrowse() {
    }

    protected void visitStatement(SSAStatement statement) {
    }

    protected void handleLoop(SSABlock block, SSAStatement recursiveStatement) {
        SSAStatement cur = recursiveStatement;
        while (cur != null) {
            this.visitStatement(cur);
            if (this.stopBrowse) {
                return;
            }
            cur = cur.getNext();
        }
    }

    public boolean doesAlwaysReach() {
        for (SSABlock block : this.visited) {
            SSABlock[] sSABlockArray = block.getExit().getSuccessors();
            int n = sSABlockArray.length;
            int n2 = 0;
            while (n2 < n) {
                SSABlock successor = sSABlockArray[n2];
                if (!this.visited.contains((Object)successor)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

